/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.internal;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.GlobUtil;

public final class IncludeExcludePredicate
implements Predicate<String> {
    private final boolean globMatchingEnabled;
    @Nullable
    private final Set<String> included;
    @Nullable
    private final Set<String> excluded;
    private final Predicate<String> predicate;

    private IncludeExcludePredicate(@Nullable Collection<String> included, @Nullable Collection<String> excluded, boolean globMatchingEnabled) {
        this.globMatchingEnabled = globMatchingEnabled;
        this.included = included == null ? null : new LinkedHashSet<String>(included);
        LinkedHashSet<String> linkedHashSet = this.excluded = excluded == null ? null : new LinkedHashSet<String>(excluded);
        if (this.included != null && this.excluded != null) {
            this.predicate = IncludeExcludePredicate.includedPredicate(this.included, globMatchingEnabled).and(IncludeExcludePredicate.excludedPredicate(this.excluded, globMatchingEnabled));
        } else if (this.included == null && this.excluded != null) {
            this.predicate = IncludeExcludePredicate.excludedPredicate(this.excluded, globMatchingEnabled);
        } else if (this.excluded == null && this.included != null) {
            this.predicate = IncludeExcludePredicate.includedPredicate(this.included, globMatchingEnabled);
        } else {
            throw new IllegalArgumentException("At least one of includedPatterns or excludedPatterns must not be null");
        }
    }

    public static Predicate<String> createExactMatching(@Nullable Collection<String> included, @Nullable Collection<String> excluded) {
        return new IncludeExcludePredicate(included, excluded, false);
    }

    public static Predicate<String> createPatternMatching(@Nullable Collection<String> included, @Nullable Collection<String> excluded) {
        return new IncludeExcludePredicate(included, excluded, true);
    }

    @Override
    public boolean test(String s2) {
        return this.predicate.test(s2);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "IncludeExcludePredicate{", "}");
        joiner.add("globMatchingEnabled=" + this.globMatchingEnabled);
        if (this.included != null) {
            joiner.add("included=" + this.included.stream().collect(Collectors.joining(", ", "[", "]")));
        }
        if (this.excluded != null) {
            joiner.add("excluded=" + this.excluded.stream().collect(Collectors.joining(", ", "[", "]")));
        }
        return joiner.toString();
    }

    private static Predicate<String> includedPredicate(Set<String> included, boolean globMatchingEnabled) {
        Predicate<String> result2 = attributeKey -> false;
        for (String include : included) {
            if (globMatchingEnabled) {
                result2 = result2.or(GlobUtil.createGlobPatternPredicate(include));
                continue;
            }
            result2 = result2.or(include::equalsIgnoreCase);
        }
        return result2;
    }

    private static Predicate<String> excludedPredicate(Set<String> excluded, boolean globMatchingEnabled) {
        Predicate<String> result2 = attributeKey -> true;
        for (String exclude : excluded) {
            if (globMatchingEnabled) {
                result2 = result2.and(GlobUtil.createGlobPatternPredicate(exclude).negate());
                continue;
            }
            result2 = result2.and(s2 -> !exclude.equalsIgnoreCase((String)s2));
        }
        return result2;
    }
}

