/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics;

import java.io.IOException;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics.ExemplarStatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics.NumberDataPointMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.proto.metrics.v1.internal.NumberDataPoint;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.DoublePointData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.LongPointData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.PointData;

final class NumberDataPointStatelessMarshaler
implements StatelessMarshaler<PointData> {
    static final NumberDataPointStatelessMarshaler INSTANCE = new NumberDataPointStatelessMarshaler();

    private NumberDataPointStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, PointData point, MarshalerContext context) throws IOException {
        output.serializeFixed64(NumberDataPoint.START_TIME_UNIX_NANO, point.getStartEpochNanos());
        output.serializeFixed64(NumberDataPoint.TIME_UNIX_NANO, point.getEpochNanos());
        ProtoFieldInfo valueField = NumberDataPointMarshaler.toProtoPointValueType(point);
        if (valueField == NumberDataPoint.AS_INT) {
            output.serializeFixed64Optional(valueField, ((LongPointData)point).getValue());
        } else {
            output.serializeDoubleOptional(valueField, ((DoublePointData)point).getValue());
        }
        output.serializeRepeatedMessageWithContext(NumberDataPoint.EXEMPLARS, point.getExemplars(), ExemplarStatelessMarshaler.INSTANCE, context);
        output.serializeRepeatedMessageWithContext(NumberDataPoint.ATTRIBUTES, point.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
    }

    @Override
    public int getBinarySerializedSize(PointData point, MarshalerContext context) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64(NumberDataPoint.START_TIME_UNIX_NANO, point.getStartEpochNanos());
        size += MarshalerUtil.sizeFixed64(NumberDataPoint.TIME_UNIX_NANO, point.getEpochNanos());
        ProtoFieldInfo valueField = NumberDataPointMarshaler.toProtoPointValueType(point);
        size = valueField == NumberDataPoint.AS_INT ? (size += MarshalerUtil.sizeFixed64Optional(valueField, ((LongPointData)point).getValue())) : (size += MarshalerUtil.sizeDoubleOptional(valueField, ((DoublePointData)point).getValue()));
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(NumberDataPoint.EXEMPLARS, point.getExemplars(), ExemplarStatelessMarshaler.INSTANCE, context);
        return size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(NumberDataPoint.ATTRIBUTES, point.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
    }
}

