/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.grpc;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.FailedExportException;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.grpc.GrpcExporterUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.grpc.GrpcResponse;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.grpc.GrpcSender;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.metrics.ExporterInstrumentation;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.InternalTelemetryVersion;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.StandardComponentId;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.ThrottlingLogger;

public final class GrpcExporter<T extends Marshaler> {
    private static final Logger internalLogger = Logger.getLogger(GrpcExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean loggedUnimplemented = new AtomicBoolean();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final String type;
    private final GrpcSender<T> grpcSender;
    private final ExporterInstrumentation exporterMetrics;

    public GrpcExporter(GrpcSender<T> grpcSender, InternalTelemetryVersion internalTelemetryVersion, StandardComponentId componentId, Supplier<MeterProvider> meterProviderSupplier, String endpoint) {
        this.type = componentId.getStandardType().signal().logFriendlyName();
        this.grpcSender = grpcSender;
        this.exporterMetrics = new ExporterInstrumentation(internalTelemetryVersion, meterProviderSupplier, componentId, endpoint);
    }

    public CompletableResultCode export(T exportRequest, int numItems) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        ExporterInstrumentation.Recording metricRecording = this.exporterMetrics.startRecordingExport(numItems);
        CompletableResultCode result2 = new CompletableResultCode();
        this.grpcSender.send(exportRequest, grpcResponse -> this.onResponse(result2, metricRecording, (GrpcResponse)grpcResponse), throwable -> this.onError(result2, metricRecording, (Throwable)throwable));
        return result2;
    }

    private void onResponse(CompletableResultCode result2, ExporterInstrumentation.Recording metricRecording, GrpcResponse grpcResponse) {
        int statusCode = grpcResponse.grpcStatusValue();
        metricRecording.setGrpcStatusCode(statusCode);
        if (statusCode == 0) {
            metricRecording.finishSuccessful();
            result2.succeed();
            return;
        }
        metricRecording.finishFailed(String.valueOf(statusCode));
        switch (statusCode) {
            case 12: {
                if (!this.loggedUnimplemented.compareAndSet(false, true)) break;
                GrpcExporterUtil.logUnimplemented(internalLogger, this.type, grpcResponse.grpcStatusDescription());
                break;
            }
            case 14: {
                this.logger.log(Level.SEVERE, "Failed to export " + this.type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + grpcResponse.grpcStatusDescription());
                break;
            }
            default: {
                this.logger.log(Level.WARNING, "Failed to export " + this.type + "s. Server responded with gRPC status code " + statusCode + ". Error message: " + grpcResponse.grpcStatusDescription());
            }
        }
        result2.failExceptionally(FailedExportException.grpcFailedWithResponse(grpcResponse));
    }

    private void onError(CompletableResultCode result2, ExporterInstrumentation.Recording metricRecording, Throwable e) {
        metricRecording.finishFailed(e);
        this.logger.log(Level.SEVERE, "Failed to export " + this.type + "s. The request could not be executed. Error message: " + e.getMessage(), e);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Failed to export " + this.type + "s. Details follow: " + e);
        }
        result2.failExceptionally(FailedExportException.grpcFailedExceptionally(e));
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.grpcSender.shutdown();
    }
}

