/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.com.google.common.collect;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ozone.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.ozone.shaded.com.google.common.annotations.GwtIncompatible;
import org.apache.ozone.shaded.com.google.common.annotations.J2ktIncompatible;
import org.apache.ozone.shaded.com.google.common.base.Supplier;
import org.apache.ozone.shaded.com.google.common.collect.CollectPreconditions;
import org.apache.ozone.shaded.com.google.common.collect.Maps;
import org.apache.ozone.shaded.com.google.common.collect.StandardTable;
import org.apache.ozone.shaded.com.google.common.collect.Table;

@GwtCompatible
public class HashBasedTable<R, C, V>
extends StandardTable<R, C, V> {
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    public static <R, C, V> HashBasedTable<R, C, V> create() {
        return new HashBasedTable(new LinkedHashMap(), new Factory(0));
    }

    public static <R, C, V> HashBasedTable<R, C, V> create(int expectedRows, int expectedCellsPerRow) {
        CollectPreconditions.checkNonnegative(expectedCellsPerRow, "expectedCellsPerRow");
        LinkedHashMap backingMap = Maps.newLinkedHashMapWithExpectedSize(expectedRows);
        return new HashBasedTable(backingMap, new Factory(expectedCellsPerRow));
    }

    public static <R, C, V> HashBasedTable<R, C, V> create(Table<? extends R, ? extends C, ? extends V> table) {
        HashBasedTable<R, C, V> result2 = HashBasedTable.create();
        result2.putAll((Table)table);
        return result2;
    }

    HashBasedTable(Map<R, Map<C, V>> backingMap, Factory<C, V> factory) {
        super(backingMap, factory);
    }

    private static final class Factory<C, V>
    implements Supplier<Map<C, V>>,
    Serializable {
        final int expectedSize;
        @GwtIncompatible
        @J2ktIncompatible
        private static final long serialVersionUID = 0L;

        Factory(int expectedSize) {
            this.expectedSize = expectedSize;
        }

        @Override
        public Map<C, V> get() {
            return Maps.newLinkedHashMapWithExpectedSize(this.expectedSize);
        }
    }
}

