/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.storage.BlockExtendedInputStream;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.hdds.scm.storage.ByteReaderStrategy;
import org.apache.hadoop.hdds.scm.storage.MultipartInputStream;
import org.apache.hadoop.hdds.scm.storage.PartInputStream;
import org.apache.hadoop.ozone.client.io.BlockInputStreamFactory;
import org.apache.hadoop.ozone.client.io.LengthInputStream;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.shaded.org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyInputStream
extends MultipartInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(KeyInputStream.class);

    public KeyInputStream(String keyName, List<? extends BlockExtendedInputStream> inputStreams) {
        super(keyName, inputStreams);
    }

    private static List<BlockExtendedInputStream> createStreams(OmKeyInfo keyInfo, List<OmKeyLocationInfo> blockInfos, XceiverClientFactory xceiverClientFactory, Function<OmKeyInfo, OmKeyInfo> retryFunction, BlockInputStreamFactory blockStreamFactory, OzoneClientConfig config) throws IOException {
        boolean isHsyncFile = keyInfo.getMetadata().containsKey("hsyncClientId");
        ArrayList<BlockExtendedInputStream> partStreams = new ArrayList<BlockExtendedInputStream>();
        for (int i = 0; i < blockInfos.size(); ++i) {
            OmKeyLocationInfo omKeyLocationInfo = blockInfos.get(i);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding stream for accessing {}. The stream will be initialized later.", (Object)omKeyLocationInfo);
            }
            Function<BlockID, BlockLocationInfo> retry = retryFunction != null ? keyBlockID -> {
                OmKeyInfo newKeyInfo = (OmKeyInfo)retryFunction.apply(keyInfo);
                return KeyInputStream.getBlockLocationInfo(newKeyInfo, omKeyLocationInfo.getBlockID());
            } : null;
            if (i == blockInfos.size() - 1 && isHsyncFile) {
                omKeyLocationInfo.setUnderConstruction(true);
            }
            BlockExtendedInputStream stream = blockStreamFactory.create(keyInfo.getReplicationConfig(), omKeyLocationInfo, omKeyLocationInfo.getPipeline(), omKeyLocationInfo.getToken(), xceiverClientFactory, retry, config);
            partStreams.add(stream);
        }
        return partStreams;
    }

    private static BlockLocationInfo getBlockLocationInfo(OmKeyInfo newKeyInfo, BlockID blockID) {
        List collect = newKeyInfo.getLatestVersionLocations().getLocationList().stream().filter(l -> l.getBlockID().equals(blockID)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            return (BlockLocationInfo)collect.get(0);
        }
        return null;
    }

    private static LengthInputStream getFromOmKeyInfo(OmKeyInfo keyInfo, XceiverClientFactory xceiverClientFactory, Function<OmKeyInfo, OmKeyInfo> retryFunction, BlockInputStreamFactory blockStreamFactory, List<OmKeyLocationInfo> locationInfos, OzoneClientConfig config) throws IOException {
        List<BlockExtendedInputStream> streams = KeyInputStream.createStreams(keyInfo, locationInfos, xceiverClientFactory, retryFunction, blockStreamFactory, config);
        KeyInputStream keyInputStream = new KeyInputStream(keyInfo.getKeyName(), (List<? extends BlockExtendedInputStream>)streams);
        return new LengthInputStream(keyInputStream, keyInputStream.getLength());
    }

    public static LengthInputStream getFromOmKeyInfo(OmKeyInfo keyInfo, XceiverClientFactory xceiverClientFactory, Function<OmKeyInfo, OmKeyInfo> retryFunction, BlockInputStreamFactory blockStreamFactory, OzoneClientConfig config) throws IOException {
        List<OmKeyLocationInfo> keyLocationInfos = keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
        return KeyInputStream.getFromOmKeyInfo(keyInfo, xceiverClientFactory, retryFunction, blockStreamFactory, keyLocationInfos, config);
    }

    public static List<LengthInputStream> getStreamsFromKeyInfo(OmKeyInfo keyInfo, XceiverClientFactory xceiverClientFactory, Function<OmKeyInfo, OmKeyInfo> retryFunction, BlockInputStreamFactory blockStreamFactory, OzoneClientConfig config) throws IOException {
        List<OmKeyLocationInfo> keyLocationInfos = keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
        Map<Integer, List<OmKeyLocationInfo>> partsToBlocksMap = keyLocationInfos.stream().collect(Collectors.groupingBy(BlockLocationInfo::getPartNumber));
        ArrayList<LengthInputStream> lengthInputStreams = new ArrayList<LengthInputStream>();
        for (List<OmKeyLocationInfo> locationInfo : partsToBlocksMap.values()) {
            lengthInputStreams.add(KeyInputStream.getFromOmKeyInfo(keyInfo, xceiverClientFactory, retryFunction, blockStreamFactory, locationInfo, config));
        }
        return lengthInputStreams;
    }

    @Override
    protected int getNumBytesToRead(ByteReaderStrategy strategy, PartInputStream current) throws IOException {
        return (int)Math.min((long)strategy.getTargetLength(), current.getRemaining());
    }

    @Override
    protected void checkPartBytesRead(int numBytesToRead, int numBytesRead, PartInputStream stream) throws IOException {
        if (numBytesRead != numBytesToRead) {
            throw new IOException(String.format("Inconsistent read for blockID=%s length=%d position=%d numBytesToRead=%d numBytesRead=%d", ((BlockExtendedInputStream)stream).getBlockID(), stream.getLength(), stream.getPos(), numBytesToRead, numBytesRead));
        }
    }

    @VisibleForTesting
    public List<BlockExtendedInputStream> getPartStreams() {
        return super.getPartStreams();
    }
}

