/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.time.Clock;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.storage.StreamBuffer;
import org.apache.hadoop.ozone.client.io.BlockDataStreamOutputEntry;
import org.apache.hadoop.ozone.client.io.KeyMetadataAware;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.security.token.Token;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockDataStreamOutputEntryPool
implements KeyMetadataAware {
    private static final Logger LOG = LoggerFactory.getLogger(BlockDataStreamOutputEntryPool.class);
    private final List<BlockDataStreamOutputEntry> streamEntries;
    private final OzoneClientConfig config;
    private int currentStreamIndex;
    private final OzoneManagerProtocol omClient;
    private final OmKeyArgs keyArgs;
    private final XceiverClientFactory xceiverClientFactory;
    private OmMultipartCommitUploadPartInfo commitUploadPartInfo;
    private final long openID;
    private final ExcludeList excludeList;
    private List<StreamBuffer> bufferList;
    private ContainerBlockID lastUpdatedBlockId = new ContainerBlockID(-1L, -1L);

    public BlockDataStreamOutputEntryPool(OzoneClientConfig config, OzoneManagerProtocol omClient, ReplicationConfig replicationConfig, String uploadID, int partNumber, boolean isMultipart, OmKeyInfo info, boolean unsafeByteBufferConversion, XceiverClientFactory xceiverClientFactory, long openID) {
        this.config = config;
        this.xceiverClientFactory = xceiverClientFactory;
        this.streamEntries = new ArrayList<BlockDataStreamOutputEntry>();
        this.currentStreamIndex = 0;
        this.omClient = omClient;
        this.keyArgs = new OmKeyArgs.Builder().setVolumeName(info.getVolumeName()).setBucketName(info.getBucketName()).setKeyName(info.getKeyName()).setReplicationConfig(replicationConfig).setDataSize(info.getDataSize()).setIsMultipartKey(isMultipart).setMultipartUploadID(uploadID).setMultipartUploadPartNumber(partNumber).setSortDatanodesInPipeline(true).build();
        this.openID = openID;
        this.excludeList = this.createExcludeList();
        this.bufferList = new ArrayList<StreamBuffer>();
    }

    public void addPreallocateBlocks(OmKeyLocationInfoGroup version, long openVersion) throws IOException {
        for (OmKeyLocationInfo subKeyInfo : version.getLocationList(openVersion)) {
            this.addKeyLocationInfo(subKeyInfo);
        }
    }

    private void addKeyLocationInfo(OmKeyLocationInfo subKeyInfo) {
        Preconditions.checkNotNull(subKeyInfo.getPipeline());
        BlockDataStreamOutputEntry.Builder builder = new BlockDataStreamOutputEntry.Builder().setBlockID(subKeyInfo.getBlockID()).setKey(this.keyArgs.getKeyName()).setXceiverClientManager(this.xceiverClientFactory).setPipeline(subKeyInfo.getPipeline()).setConfig(this.config).setLength(subKeyInfo.getLength()).setToken(subKeyInfo.getToken()).setBufferList(this.bufferList);
        this.streamEntries.add(builder.build());
    }

    public List<OmKeyLocationInfo> getLocationInfoList() {
        ArrayList<OmKeyLocationInfo> locationInfoList = new ArrayList<OmKeyLocationInfo>();
        for (BlockDataStreamOutputEntry streamEntry : this.streamEntries) {
            long length = streamEntry.getCurrentPosition();
            if (length != 0L) {
                OmKeyLocationInfo info = ((OmKeyLocationInfo.Builder)new OmKeyLocationInfo.Builder().setBlockID(streamEntry.getBlockID()).setLength(streamEntry.getCurrentPosition()).setOffset(0L).setToken((Token)streamEntry.getToken())).setPipeline(streamEntry.getPipeline()).build();
                locationInfoList.add(info);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("block written " + streamEntry.getBlockID() + ", length " + length + " bcsID " + streamEntry.getBlockID().getBlockCommitSequenceId());
        }
        return locationInfoList;
    }

    void hsyncKey(long offset) throws IOException {
        if (this.keyArgs != null) {
            this.keyArgs.setDataSize(offset);
            this.keyArgs.setLocationInfoList(this.getLocationInfoList());
            if (this.keyArgs.getIsMultipartKey()) {
                throw new IOException("Hsync is unsupported for multipart keys.");
            }
            if (this.keyArgs.getLocationInfoList().isEmpty()) {
                this.omClient.hsyncKey(this.keyArgs, this.openID);
            } else {
                ContainerBlockID lastBLockId = this.keyArgs.getLocationInfoList().get(this.keyArgs.getLocationInfoList().size() - 1).getBlockID().getContainerBlockID();
                if (!this.lastUpdatedBlockId.equals(lastBLockId)) {
                    this.omClient.hsyncKey(this.keyArgs, this.openID);
                    this.lastUpdatedBlockId = lastBLockId;
                }
            }
        } else {
            LOG.warn("Closing KeyOutputStream, but key args is null");
        }
    }

    void discardPreallocatedBlocks(long containerID, PipelineID pipelineId) {
        if (this.currentStreamIndex + 1 < this.streamEntries.size()) {
            ListIterator<BlockDataStreamOutputEntry> streamEntryIterator = this.streamEntries.listIterator(this.currentStreamIndex + 1);
            while (streamEntryIterator.hasNext()) {
                BlockDataStreamOutputEntry streamEntry = streamEntryIterator.next();
                Preconditions.checkArgument(streamEntry.getCurrentPosition() == 0L);
                if (!streamEntry.getPipeline().getId().equals(pipelineId) && (containerID == -1L || streamEntry.getBlockID().getContainerID() != containerID)) continue;
                streamEntryIterator.remove();
            }
        }
    }

    List<BlockDataStreamOutputEntry> getStreamEntries() {
        return this.streamEntries;
    }

    XceiverClientFactory getXceiverClientFactory() {
        return this.xceiverClientFactory;
    }

    String getKeyName() {
        return this.keyArgs.getKeyName();
    }

    long getKeyLength() {
        return this.streamEntries.stream().mapToLong(BlockDataStreamOutputEntry::getCurrentPosition).sum();
    }

    private void allocateNewBlock() throws IOException {
        if (!this.excludeList.isEmpty()) {
            LOG.debug("Allocating block with {}", (Object)this.excludeList);
        }
        OmKeyLocationInfo subKeyInfo = this.omClient.allocateBlock(this.keyArgs, this.openID, this.excludeList);
        this.addKeyLocationInfo(subKeyInfo);
    }

    void commitKey(long offset) throws IOException {
        if (this.keyArgs != null) {
            long length = this.getKeyLength();
            Preconditions.checkArgument(offset == length);
            this.keyArgs.setDataSize(length);
            this.keyArgs.setLocationInfoList(this.getLocationInfoList());
            if (this.keyArgs.getIsMultipartKey()) {
                this.commitUploadPartInfo = this.omClient.commitMultipartUploadPart(this.keyArgs, this.openID);
            } else {
                this.omClient.commitKey(this.keyArgs, this.openID);
            }
        } else {
            LOG.warn("Closing KeyDataStreamOutput, but key args is null");
        }
    }

    public BlockDataStreamOutputEntry getCurrentStreamEntry() {
        if (this.streamEntries.isEmpty() || this.streamEntries.size() <= this.currentStreamIndex) {
            return null;
        }
        return this.streamEntries.get(this.currentStreamIndex);
    }

    BlockDataStreamOutputEntry allocateBlockIfNeeded() throws IOException {
        BlockDataStreamOutputEntry streamEntry = this.getCurrentStreamEntry();
        if (streamEntry != null && streamEntry.isClosed()) {
            ++this.currentStreamIndex;
        }
        if (this.streamEntries.size() <= this.currentStreamIndex) {
            Preconditions.checkNotNull(this.omClient);
            this.allocateNewBlock();
        }
        Preconditions.checkArgument(this.currentStreamIndex < this.streamEntries.size());
        return this.streamEntries.get(this.currentStreamIndex);
    }

    void cleanup() {
        if (this.excludeList != null) {
            this.excludeList.clear();
        }
        if (this.streamEntries != null) {
            this.streamEntries.clear();
        }
    }

    public OmMultipartCommitUploadPartInfo getCommitUploadPartInfo() {
        return this.commitUploadPartInfo;
    }

    public ExcludeList getExcludeList() {
        return this.excludeList;
    }

    boolean isEmpty() {
        return this.streamEntries.isEmpty();
    }

    long computeBufferData() {
        long totalDataLen = 0L;
        for (StreamBuffer b : this.bufferList) {
            totalDataLen += (long)b.position();
        }
        return totalDataLen;
    }

    OzoneClientConfig getConfig() {
        return this.config;
    }

    ExcludeList createExcludeList() {
        return new ExcludeList(this.getConfig().getExcludeNodesExpiryTime(), Clock.system(ZoneOffset.UTC));
    }

    public long getDataSize() {
        return this.keyArgs.getDataSize();
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.keyArgs.getMetadata();
    }
}

