/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToIntFunction;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.ozone.shaded.jakarta.annotation.Nonnull;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.MessageLite;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.Parser;

public final class Proto3Codec<M extends MessageLite>
implements Codec<M> {
    private static final ConcurrentMap<Class<? extends MessageLite>, Codec<? extends MessageLite>> CODECS = new ConcurrentHashMap<Class<? extends MessageLite>, Codec<? extends MessageLite>>();
    private final Class<M> clazz;
    private final Parser<M> parser;
    private final boolean allowInvalidProtocolBufferException;

    public static <T extends MessageLite> Codec<T> get(T t2) {
        return Proto3Codec.get(t2, false);
    }

    public static <T extends MessageLite> Codec<T> get(T t2, boolean allowInvalidProtocolBufferException) {
        Codec codec = CODECS.computeIfAbsent(t2.getClass(), key -> new Proto3Codec<MessageLite>(t2, allowInvalidProtocolBufferException));
        return codec;
    }

    private Proto3Codec(M m4, boolean allowInvalidProtocolBufferException) {
        this.clazz = m4.getClass();
        this.parser = m4.getParserForType();
        this.allowInvalidProtocolBufferException = allowInvalidProtocolBufferException;
    }

    @Override
    public Class<M> getTypeClass() {
        return this.clazz;
    }

    @Override
    public boolean supportCodecBuffer() {
        return true;
    }

    @Override
    public CodecBuffer toCodecBuffer(@Nonnull M message, CodecBuffer.Allocator allocator) {
        int size = message.getSerializedSize();
        CodecBuffer codecBuffer = (CodecBuffer)allocator.apply(size);
        ToIntFunction<ByteBuffer> writeTo = buffer -> {
            try {
                message.writeTo(CodedOutputStream.newInstance(buffer));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to writeTo: message=" + message, e);
            }
            return size;
        };
        codecBuffer.put(writeTo);
        return codecBuffer;
    }

    @Override
    public M fromCodecBuffer(@Nonnull CodecBuffer buffer) throws CodecException {
        try {
            return (M)((MessageLite)this.parser.parseFrom(buffer.asReadOnlyByteBuffer()));
        }
        catch (InvalidProtocolBufferException e) {
            if (this.allowInvalidProtocolBufferException) {
                return null;
            }
            throw new CodecException("Failed to parse " + buffer + " for " + this.getTypeClass(), e);
        }
    }

    @Override
    public byte[] toPersistedFormat(M message) {
        return message.toByteArray();
    }

    @Override
    public M fromPersistedFormatImpl(byte[] bytes) throws InvalidProtocolBufferException {
        try {
            return (M)((MessageLite)this.parser.parseFrom(bytes));
        }
        catch (InvalidProtocolBufferException e) {
            if (this.allowInvalidProtocolBufferException) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public M copyObject(M message) {
        return message;
    }
}

