/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.ozone.shaded.jakarta.annotation.Nonnull;
import org.apache.ozone.shaded.org.apache.ratis.util.AtomicFileOutputStream;
import org.slf4j.Logger;

public final class IOUtils {
    private IOUtils() {
    }

    public static void cleanupWithLogger(Logger logger, AutoCloseable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (AutoCloseable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Throwable e) {
                if (logger == null) continue;
                logger.debug("Exception in closing {}", (Object)c, (Object)e);
            }
        }
    }

    public static void close(Logger logger, AutoCloseable ... closeables) {
        IOUtils.close(logger, Arrays.asList(closeables));
    }

    public static void close(Logger logger, Collection<? extends AutoCloseable> closeables) {
        if (closeables == null) {
            return;
        }
        for (AutoCloseable autoCloseable : closeables) {
            if (autoCloseable == null) continue;
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                if (logger == null) continue;
                logger.error("Exception in closing {}", (Object)autoCloseable, (Object)e);
            }
        }
    }

    public static void closeQuietly(AutoCloseable ... closeables) {
        IOUtils.close(null, closeables);
    }

    public static void closeQuietly(Collection<? extends AutoCloseable> closeables) {
        IOUtils.close(null, closeables);
    }

    public static void writePropertiesToFile(File file, Properties properties) throws IOException {
        try (AtomicFileOutputStream out = new AtomicFileOutputStream(file);){
            properties.store(out, null);
        }
    }

    @Nonnull
    public static Properties readPropertiesFromFile(File file) throws IOException {
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            props.load(in);
        }
        return props;
    }
}

