/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import org.apache.hadoop.hdds.tracing.GrpcClientInterceptor;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.Span;
import org.apache.ozone.shaded.io.opentelemetry.context.Scope;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ForwardingServerCallListener;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Metadata;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ServerCall;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ServerCallHandler;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ServerInterceptor;

public class GrpcServerInterceptor
implements ServerInterceptor {
    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessage(ReqT message) {
                Span span = TracingUtil.importAndCreateSpan(call.getMethodDescriptor().getFullMethodName(), headers.get(GrpcClientInterceptor.TRACING_HEADER));
                try (Scope ignored = span.makeCurrent();){
                    super.onMessage(message);
                }
                finally {
                    span.end();
                }
            }
        };
    }
}

