/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.hdds.scm.storage.ByteArrayReader;
import org.apache.hadoop.hdds.scm.storage.ByteBufferReader;
import org.apache.hadoop.hdds.scm.storage.ByteReaderStrategy;
import org.apache.hadoop.util.StringUtils;
import org.apache.ozone.shaded.org.apache.commons.lang3.NotImplementedException;

public abstract class ExtendedInputStream
extends InputStream
implements Seekable,
CanUnbuffer,
ByteBufferReadable,
StreamCapabilities {
    protected static final int EOF = -1;

    @Override
    public synchronized int read() throws IOException {
        byte[] buf = new byte[1];
        if (this.read(buf, 0, 1) == -1) {
            return -1;
        }
        return Byte.toUnsignedInt(buf[0]);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        ByteArrayReader strategy = new ByteArrayReader(b, off, len);
        int bufferLen = strategy.getTargetLength();
        if (bufferLen == 0) {
            return 0;
        }
        return this.readWithStrategy(strategy);
    }

    public synchronized int read(ByteBuffer byteBuffer) throws IOException {
        ByteBufferReader strategy = new ByteBufferReader(byteBuffer);
        int bufferLen = strategy.getTargetLength();
        if (bufferLen == 0) {
            return 0;
        }
        return this.readWithStrategy(strategy);
    }

    protected abstract int readWithStrategy(ByteReaderStrategy var1) throws IOException;

    public synchronized void seek(long l) throws IOException {
        throw new NotImplementedException("Seek is not implemented");
    }

    public synchronized boolean seekToNewSource(long l) throws IOException {
        return false;
    }

    public boolean hasCapability(String capability) {
        switch (StringUtils.toLowerCase((String)capability)) {
            case "in:readbytebuffer": 
            case "in:unbuffer": {
                return true;
            }
        }
        return false;
    }
}

