/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;

public class ReplicationManagerReport {
    public static final int SAMPLE_LIMIT = 100;
    private long reportTimeStamp;
    private final Map<String, LongAdder> stats;
    private final Map<String, List<ContainerID>> containerSample = new ConcurrentHashMap<String, List<ContainerID>>();

    public static ReplicationManagerReport fromProtobuf(HddsProtos.ReplicationManagerReportProto proto) {
        ReplicationManagerReport report = new ReplicationManagerReport();
        report.setTimestamp(proto.getTimestamp());
        for (HddsProtos.KeyIntValue stat : proto.getStatList()) {
            report.setStat(stat.getKey(), stat.getValue());
        }
        for (HddsProtos.KeyContainerIDList sample : proto.getStatSampleList()) {
            report.setSample(sample.getKey(), sample.getContainerList().stream().map(ContainerID::getFromProtobuf).collect(Collectors.toList()));
        }
        return report;
    }

    public ReplicationManagerReport() {
        this.stats = this.createStatsMap();
    }

    public void increment(HealthState stat) {
        this.increment(stat.toString());
    }

    public void increment(HddsProtos.LifeCycleState stat) {
        this.increment(stat.toString());
    }

    public void incrementAndSample(HealthState stat, ContainerID container) {
        this.incrementAndSample(stat.toString(), container);
    }

    public void setComplete() {
        this.reportTimeStamp = System.currentTimeMillis();
    }

    public long getReportTimeStamp() {
        return this.reportTimeStamp;
    }

    public Map<String, Long> getStats() {
        HashMap<String, Long> result2 = new HashMap<String, Long>();
        for (Map.Entry<String, LongAdder> e : this.stats.entrySet()) {
            result2.put(e.getKey(), e.getValue().longValue());
        }
        return result2;
    }

    public Map<String, List<Long>> getSamples() {
        HashMap<String, List<Long>> result2 = new HashMap<String, List<Long>>();
        for (Map.Entry<String, List<ContainerID>> e : this.containerSample.entrySet()) {
            result2.put(e.getKey(), e.getValue().stream().map(c -> c.getId()).collect(Collectors.toList()));
        }
        return result2;
    }

    public long getStat(HddsProtos.LifeCycleState stat) {
        return this.getStat(stat.toString());
    }

    public long getStat(HealthState stat) {
        return this.getStat(stat.toString());
    }

    private long getStat(String stat) {
        LongAdder val = this.stats.get(stat);
        if (val == null) {
            return -1L;
        }
        return val.longValue();
    }

    protected void setTimestamp(long timestamp) {
        this.reportTimeStamp = timestamp;
    }

    protected void setStat(String stat, long value) {
        LongAdder adder = this.stats.get(stat);
        if (adder == null) {
            return;
        }
        if (adder.longValue() != 0L) {
            throw new IllegalStateException(stat + " is expected to be zero");
        }
        adder.add(value);
    }

    protected void setSample(String stat, List<ContainerID> sample) {
        LongAdder adder = this.stats.get(stat);
        if (adder == null) {
            return;
        }
        List<ContainerID> existingSample = this.containerSample.get(stat);
        if (existingSample != null) {
            throw new IllegalStateException(stat + " is not expected to have existing samples");
        }
        this.containerSample.put(stat, sample);
    }

    public List<ContainerID> getSample(HealthState stat) {
        return this.getSample(stat.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ContainerID> getSample(String stat) {
        List<ContainerID> list = this.containerSample.get(stat);
        if (list == null) {
            return Collections.emptyList();
        }
        List<ContainerID> list2 = list;
        synchronized (list2) {
            return new ArrayList<ContainerID>(list);
        }
    }

    private void increment(String stat) {
        this.getStatAndEnsurePresent(stat).increment();
    }

    private LongAdder getStatAndEnsurePresent(String stat) {
        LongAdder adder = this.stats.get(stat);
        if (adder == null) {
            throw new IllegalArgumentException("Unexpected stat " + stat);
        }
        return adder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementAndSample(String stat, ContainerID container) {
        List list;
        this.increment(stat);
        List list2 = list = this.containerSample.computeIfAbsent(stat, k -> new ArrayList());
        synchronized (list2) {
            if (list.size() < 100) {
                list.add(container);
            }
        }
    }

    private Map<String, LongAdder> createStatsMap() {
        HashMap<String, LongAdder> map = new HashMap<String, LongAdder>();
        for (HddsProtos.LifeCycleState lifeCycleState : HddsProtos.LifeCycleState.values()) {
            map.put(lifeCycleState.toString(), new LongAdder());
        }
        for (Enum enum_ : HealthState.values()) {
            map.put(enum_.toString(), new LongAdder());
        }
        return map;
    }

    public HddsProtos.ReplicationManagerReportProto toProtobuf() {
        HddsProtos.ReplicationManagerReportProto.Builder proto = HddsProtos.ReplicationManagerReportProto.newBuilder();
        proto.setTimestamp(this.getReportTimeStamp());
        for (Map.Entry<String, LongAdder> entry : this.stats.entrySet()) {
            proto.addStat(HddsProtos.KeyIntValue.newBuilder().setKey(entry.getKey()).setValue(entry.getValue().longValue()).build());
        }
        for (Map.Entry<String, Object> entry : this.containerSample.entrySet()) {
            HddsProtos.KeyContainerIDList.Builder sample = HddsProtos.KeyContainerIDList.newBuilder();
            sample.setKey(entry.getKey());
            for (ContainerID container : (List)entry.getValue()) {
                sample.addContainer(container.getProtobuf());
            }
            proto.addStatSample(sample.build());
        }
        return proto.build();
    }

    public static enum HealthState {
        UNDER_REPLICATED("Containers with insufficient replicas", "UnderReplicatedContainers"),
        MIS_REPLICATED("Containers with insufficient racks", "MisReplicatedContainers"),
        OVER_REPLICATED("Containers with more replicas than required", "OverReplicatedContainers"),
        MISSING("Containers with no online replicas", "MissingContainers"),
        UNHEALTHY("Containers Closed or Quasi_Closed having some replicas in a different state", "UnhealthyContainers"),
        EMPTY("Containers having no blocks", "EmptyContainers"),
        OPEN_UNHEALTHY("Containers open and having replicas with different states", "OpenUnhealthyContainers"),
        QUASI_CLOSED_STUCK("Containers QuasiClosed with insufficient datanode origins", "StuckQuasiClosedContainers"),
        OPEN_WITHOUT_PIPELINE("Containers in OPEN state without any healthy Pipeline", "OpenContainersWithoutPipeline");

        private String description;
        private String metricName;

        private HealthState(String desc, String name) {
            this.description = desc;
            this.metricName = name;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

