/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.cli;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.ozone.shaded.jakarta.annotation.Nonnull;

public abstract class ItemsFromStdin
implements Iterable<String> {
    protected static final String FORMAT_DESCRIPTION = ": one or more, separated by spaces. To read from stdin, specify '-' and supply one item per line.";
    private List<String> items;

    protected void setItems(List<String> arguments) {
        this.items = ItemsFromStdin.readItemsFromStdinIfNeeded(arguments);
    }

    public List<String> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    @Nonnull
    public Iterator<String> iterator() {
        return this.items.iterator();
    }

    public int size() {
        return this.items.size();
    }

    private static List<String> readItemsFromStdinIfNeeded(List<String> parameters) {
        if (parameters.isEmpty() || !"-".equals(parameters.iterator().next())) {
            return parameters;
        }
        ArrayList<String> items = new ArrayList<String>();
        Scanner scanner = new Scanner(System.in, StandardCharsets.UTF_8.name());
        while (scanner.hasNextLine()) {
            items.add(scanner.nextLine().trim());
        }
        return items;
    }
}

