/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;

@InterfaceAudience.Private
public class OzoneDelegationTokenRenewer
extends TokenRenewer {
    public Text getKind() {
        return OzoneTokenIdentifier.KIND_NAME;
    }

    public boolean handleKind(Text kind) {
        return this.getKind().equals((Object)kind);
    }

    public boolean isManaged(Token<?> token) {
        return true;
    }

    public long renew(Token<?> token, Configuration conf) throws IOException {
        Token<?> ozoneDt = token;
        OzoneConfiguration ozoneConf = OzoneConfiguration.of(conf);
        try (OzoneClient ozoneClient = OzoneClientFactory.getOzoneClient(ozoneConf, ozoneDt);){
            long l = ozoneClient.getObjectStore().renewDelegationToken(ozoneDt);
            return l;
        }
    }

    public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        Token<?> ozoneDt = token;
        OzoneConfiguration ozoneConf = OzoneConfiguration.of(conf);
        try (OzoneClient ozoneClient = OzoneClientFactory.getOzoneClient(ozoneConf, ozoneDt);){
            ozoneClient.getObjectStore().cancelDelegationToken(ozoneDt);
        }
    }

    static {
        OzoneConfiguration.activate();
    }
}

