/*
 * Decompiled with CFR 0.152.
 */
package io.reflectoring.diffparser.api;

import io.reflectoring.diffparser.api.DiffParser;
import io.reflectoring.diffparser.api.model.Diff;
import io.reflectoring.diffparser.api.model.Hunk;
import io.reflectoring.diffparser.api.model.Line;
import io.reflectoring.diffparser.api.model.Range;
import io.reflectoring.diffparser.unified.ParserState;
import io.reflectoring.diffparser.unified.ResizingParseWindow;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnifiedDiffParser
implements DiffParser {
    public static final Pattern LINE_RANGE_PATTERN = Pattern.compile("^.*-([0-9]+)(?:,([0-9]+))? \\+([0-9]+)(?:,([0-9]+))?.*$");

    @Override
    public List<Diff> parse(InputStream in) {
        String currentLine;
        ResizingParseWindow window = new ResizingParseWindow(in);
        ParserState state = ParserState.INITIAL;
        ArrayList<Diff> parsedDiffs = new ArrayList<Diff>();
        Diff currentDiff = new Diff();
        block11: while ((currentLine = window.slideForward()) != null) {
            state = state.nextState(window);
            switch (state) {
                case INITIAL: {
                    continue block11;
                }
                case HEADER: {
                    this.parseHeader(currentDiff, currentLine);
                    continue block11;
                }
                case FROM_FILE: {
                    this.parseFromFile(currentDiff, currentLine);
                    continue block11;
                }
                case TO_FILE: {
                    this.parseToFile(currentDiff, currentLine);
                    continue block11;
                }
                case HUNK_START: {
                    this.parseHunkStart(currentDiff, currentLine);
                    continue block11;
                }
                case FROM_LINE: {
                    this.parseFromLine(currentDiff, currentLine);
                    continue block11;
                }
                case TO_LINE: {
                    this.parseToLine(currentDiff, currentLine);
                    continue block11;
                }
                case NEUTRAL_LINE: {
                    this.parseNeutralLine(currentDiff, currentLine);
                    continue block11;
                }
                case END: {
                    parsedDiffs.add(currentDiff);
                    currentDiff = new Diff();
                    continue block11;
                }
            }
            throw new IllegalStateException(String.format("Illegal parser state '%s", new Object[]{state}));
        }
        return parsedDiffs;
    }

    private void parseNeutralLine(Diff currentDiff, String currentLine) {
        Line line = new Line(Line.LineType.NEUTRAL, currentLine);
        currentDiff.getLatestHunk().getLines().add(line);
    }

    private void parseToLine(Diff currentDiff, String currentLine) {
        Line toLine = new Line(Line.LineType.TO, currentLine.substring(1));
        currentDiff.getLatestHunk().getLines().add(toLine);
    }

    private void parseFromLine(Diff currentDiff, String currentLine) {
        Line fromLine = new Line(Line.LineType.FROM, currentLine.substring(1));
        currentDiff.getLatestHunk().getLines().add(fromLine);
    }

    private void parseHunkStart(Diff currentDiff, String currentLine) {
        Matcher matcher = LINE_RANGE_PATTERN.matcher(currentLine);
        if (!matcher.matches()) {
            throw new IllegalStateException(String.format("No line ranges found in the following hunk start line: '%s'. Expected something like '-1,5 +3,5'.", currentLine));
        }
        String range1Start = matcher.group(1);
        String range1Count = matcher.group(2) != null ? matcher.group(2) : "1";
        Range fromRange = new Range(Integer.valueOf(range1Start), Integer.valueOf(range1Count));
        String range2Start = matcher.group(3);
        String range2Count = matcher.group(4) != null ? matcher.group(4) : "1";
        Range toRange = new Range(Integer.valueOf(range2Start), Integer.valueOf(range2Count));
        Hunk hunk = new Hunk();
        hunk.setFromFileRange(fromRange);
        hunk.setToFileRange(toRange);
        currentDiff.getHunks().add(hunk);
    }

    private void parseToFile(Diff currentDiff, String currentLine) {
        currentDiff.setToFileName(this.cutAfterTab(currentLine.substring(4)));
    }

    private void parseFromFile(Diff currentDiff, String currentLine) {
        currentDiff.setFromFileName(this.cutAfterTab(currentLine.substring(4)));
    }

    private String cutAfterTab(String line) {
        Pattern p = Pattern.compile("^(.*)\\t.*$");
        Matcher matcher = p.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return line;
    }

    private void parseHeader(Diff currentDiff, String currentLine) {
        currentDiff.getHeaderLines().add(currentLine);
    }

    @Override
    public List<Diff> parse(byte[] bytes) {
        return this.parse(new ByteArrayInputStream(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Diff> parse(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            List<Diff> list = this.parse(in);
            return list;
        }
    }
}

