/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.swagger2.mappers.PropertyMapper;

public class CompoundSpecificationToPropertyConverter
implements Converter<CompoundModelSpecification, Property> {
    private final ModelNamesRegistry modelNamesRegistry;

    public CompoundSpecificationToPropertyConverter(ModelNamesRegistry modelNamesRegistry) {
        this.modelNamesRegistry = modelNamesRegistry;
    }

    public Property convert(CompoundModelSpecification source) {
        ObjectProperty schema = new ObjectProperty();
        schema.properties(source.getProperties().stream().map(p -> {
            Property property = new PropertyMapper().fromModel(p.getType(), this.modelNamesRegistry);
            if (property != null) {
                property.setName(p.getName());
                return property;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Property::getName, s -> s)));
        return schema;
    }
}

