/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.sink;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;

public class DataLakeSinkConfig
extends SinkConfig {
    @NotBlank
    @Pattern(regexp="^(((file|hdfs)://)|/).*", message="Invalid path URI, please set the following allowed schemas: 'file://' or 'hdfs://'(default).")
    private @NotBlank @Pattern(regexp="^(((file|hdfs)://)|/).*", message="Invalid path URI, please set the following allowed schemas: 'file://' or 'hdfs://'(default).") String path;
    @NotBlank
    @Pattern(regexp="^(delta|hudi)$", message="Unknown table format: {saveMode}. Accepted save modes are 'delta', 'hudi'.")
    private @NotBlank @Pattern(regexp="^(delta|hudi)$", message="Unknown table format: {saveMode}. Accepted save modes are 'delta', 'hudi'.") String tableFormat = "delta";
    @NotBlank
    @Pattern(regexp="^(overwrite|append|ignore|error|errorifexists)$", message="Unknown save mode: {saveMode}. Accepted save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists'.")
    private @NotBlank @Pattern(regexp="^(overwrite|append|ignore|error|errorifexists)$", message="Unknown save mode: {saveMode}. Accepted save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists'.") String saveMode = "overwrite";

    public String getPath() {
        if (this.path.startsWith("/")) {
            return "hdfs://" + this.path;
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSaveMode() {
        return this.saveMode;
    }

    public void setSaveMode(String saveMode) {
        this.saveMode = saveMode;
    }

    public String getTableFormat() {
        return this.tableFormat;
    }

    public void setTableFormat(String tableFormat) {
        this.tableFormat = tableFormat;
    }
}

