/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.excel;

import com.github.pjfanning.xlsx.StreamingReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class XlsxUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<String>> getBasicInfo(InputStream inputStream, File file) throws Exception {
        try {
            ArrayList res = new ArrayList();
            Workbook wb = null;
            wb = inputStream != null ? StreamingReader.builder().rowCacheSize(2).open(inputStream) : StreamingReader.builder().rowCacheSize(2).open(file);
            ArrayList<String> sheetNames = new ArrayList<String>();
            for (Sheet sheet : wb) {
                sheetNames.add(sheet.getSheetName());
            }
            Sheet sheet = wb.getSheetAt(0);
            Iterator iterator = sheet.iterator();
            Row row = null;
            while (iterator.hasNext() && row == null) {
                row = (Row)iterator.next();
            }
            if (row == null) {
                throw new Exception("The incoming Excel file is empty(\u4f20\u5165\u7684Excel\u6587\u4ef6\u4e3a\u7a7a)");
            }
            ArrayList<String> values = new ArrayList<String>();
            for (Cell cell : row) {
                values.add(cell.getStringCellValue());
            }
            res.add(sheetNames);
            res.add(values);
            ArrayList arrayList = res;
            return arrayList;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<Map<String, String>>> getAllSheetInfo(InputStream inputStream, File file, Boolean hasHeader) throws IOException {
        try {
            Workbook wb = null;
            wb = inputStream != null ? StreamingReader.builder().rowCacheSize(2).open(inputStream) : StreamingReader.builder().rowCacheSize(2).open(file);
            LinkedHashMap res = new LinkedHashMap(wb.getNumberOfSheets());
            for (Sheet sheet : wb) {
                Iterator iterator = sheet.iterator();
                Row row = null;
                while (iterator.hasNext() && row == null) {
                    row = (Row)iterator.next();
                }
                ArrayList rowList = new ArrayList();
                if (row == null) {
                    res.put(sheet.getSheetName(), rowList);
                    continue;
                }
                int cellIdx = 0;
                for (Cell cell : row) {
                    LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
                    if (hasHeader.booleanValue()) {
                        item.put(cell.getStringCellValue(), "string");
                    } else {
                        item.put("col_" + (cellIdx + 1), "string");
                    }
                    ++cellIdx;
                    rowList.add(item);
                }
                res.put(sheet.getSheetName(), rowList);
            }
            LinkedHashMap linkedHashMap = res;
            return linkedHashMap;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

