/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.condition.construction;

import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.common.entity.enumeration.ContextScope;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.condition.AtomicCondition;
import org.apache.linkis.cs.condition.Condition;
import org.apache.linkis.cs.condition.construction.ConditionBuilder;
import org.apache.linkis.cs.condition.impl.ContainsCondition;
import org.apache.linkis.cs.condition.impl.ContextScopeCondition;
import org.apache.linkis.cs.condition.impl.ContextTypeCondition;
import org.apache.linkis.cs.condition.impl.RegexCondition;

public class ConditionBuilderImpl
implements ConditionBuilder {
    Collection<ContextType> contextTypes;
    Collection<ContextScope> contextScopes;
    String regex;
    String containsValue;

    @Override
    public ConditionBuilder contextTypes(Collection<ContextType> contextTypes) {
        this.contextTypes = contextTypes;
        return this;
    }

    @Override
    public ConditionBuilder contextScopes(Collection<ContextScope> contextScopes) {
        this.contextScopes = contextScopes;
        return this;
    }

    @Override
    public ConditionBuilder regex(String regex) {
        this.regex = regex;
        return this;
    }

    @Override
    public ConditionBuilder contains(String value) {
        this.containsValue = value;
        return this;
    }

    @Override
    public Condition build() {
        AtomicCondition subCondition;
        Condition condition = null;
        if (CollectionUtils.isNotEmpty(this.contextTypes)) {
            for (ContextType contextType : this.contextTypes) {
                ContextTypeCondition subCondition2 = new ContextTypeCondition(contextType);
                condition = this.combineCondition(condition, subCondition2, true);
            }
        }
        Condition conditionContextScope = null;
        if (CollectionUtils.isNotEmpty(this.contextScopes)) {
            for (ContextScope contextScope : this.contextScopes) {
                ContextScopeCondition subCondition3 = new ContextScopeCondition(contextScope);
                conditionContextScope = this.combineCondition(conditionContextScope, subCondition3, true);
            }
            condition = this.combineCondition(condition, conditionContextScope, false);
        }
        if (StringUtils.isNotBlank((CharSequence)this.regex)) {
            subCondition = new RegexCondition(this.regex);
            condition = this.combineCondition(condition, subCondition, false);
        }
        if (StringUtils.isNotBlank((CharSequence)this.containsValue)) {
            subCondition = new ContainsCondition(this.containsValue);
            condition = this.combineCondition(condition, subCondition, false);
        }
        return condition;
    }

    private Condition combineCondition(Condition condition, Condition subCondition, boolean or) {
        condition = condition == null ? subCondition : (or ? condition.or(subCondition) : condition.and(subCondition));
        return condition;
    }
}

