/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.metadata.query.common.domain.GenerateSqlInfo;
import org.apache.linkis.metadata.query.common.domain.MetaColumnInfo;
import org.apache.linkis.metadata.query.common.service.GenerateSqlTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlConnection
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSqlConnection.class);
    public Connection conn;
    public ConnectMessage connectMessage;

    public AbstractSqlConnection(String host, Integer port, String username, String password, String database, Map<String, Object> extraParams) throws ClassNotFoundException, SQLException {
        this.connectMessage = new ConnectMessage(host, port, username, password, extraParams);
        this.conn = this.getDBConnection(this.connectMessage, database);
        Statement statement = this.conn.createStatement();
        statement.close();
    }

    public abstract Connection getDBConnection(ConnectMessage var1, String var2) throws ClassNotFoundException, SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetaColumnInfo> getColumns(String schemaname, String table) throws SQLException, ClassNotFoundException {
        ArrayList<MetaColumnInfo> columns = new ArrayList<MetaColumnInfo>();
        String columnSql = "SELECT * FROM " + schemaname + "." + table + " WHERE 1 = 2";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            List<String> primaryKeys = this.getPrimaryKeys(table);
            ps = this.conn.prepareStatement(columnSql);
            rs = ps.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            for (int i = 1; i < columnCount + 1; ++i) {
                MetaColumnInfo info = new MetaColumnInfo();
                info.setIndex(i);
                info.setLength(meta.getColumnDisplaySize(i));
                info.setNullable(meta.isNullable(i) == 1);
                info.setName(meta.getColumnName(i));
                info.setType(meta.getColumnTypeName(i));
                if (primaryKeys.contains(meta.getColumnName(i))) {
                    info.setPrimaryKey(true);
                }
                columns.add(info);
            }
            this.closeResource(null, ps, rs);
        }
        catch (Throwable throwable) {
            this.closeResource(null, ps, rs);
            throw throwable;
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPrimaryKeys(String table) throws SQLException {
        ResultSet rs = null;
        ArrayList<String> primaryKeys = new ArrayList<String>();
        try {
            DatabaseMetaData dbMeta = this.conn.getMetaData();
            rs = dbMeta.getPrimaryKeys(null, null, table);
            while (rs.next()) {
                primaryKeys.add(rs.getString("column_name"));
            }
            ArrayList<String> arrayList = primaryKeys;
            return arrayList;
        }
        finally {
            if (null != rs) {
                rs.close();
            }
        }
    }

    public GenerateSqlInfo queryJdbcSql(String database, String table) {
        GenerateSqlInfo generateSqlInfo = new GenerateSqlInfo();
        String ddl = this.generateJdbcDdlSql(database, table);
        generateSqlInfo.setDdl(ddl);
        generateSqlInfo.setDml(GenerateSqlTemplate.generateDmlSql((String)table));
        String columnStr = "*";
        try {
            List<MetaColumnInfo> columns = this.getColumns(database, table);
            if (CollectionUtils.isNotEmpty(columns)) {
                columnStr = columns.stream().map(column -> column.getName()).collect(Collectors.joining(","));
            }
        }
        catch (Exception e) {
            LOG.warn("Fail to get Sql columns(\u83b7\u53d6\u5b57\u6bb5\u5217\u8868\u5931\u8d25)", (Throwable)e);
        }
        generateSqlInfo.setDql(GenerateSqlTemplate.generateDqlSql((String)columnStr, (String)table));
        return generateSqlInfo;
    }

    public String generateJdbcDdlSql(String database, String table) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE TABLE ").append(String.format("%s.%s", database, table)).append(" (");
        try {
            List<MetaColumnInfo> columns = this.getColumns(database, table);
            if (CollectionUtils.isNotEmpty(columns)) {
                for (MetaColumnInfo column : columns) {
                    ddl.append("\n\t").append(column.getName()).append(" ").append(column.getType());
                    if (column.getLength() > 0) {
                        ddl.append("(").append(column.getLength()).append(")");
                    }
                    if (!column.isNullable()) {
                        ddl.append(" NOT NULL");
                    }
                    ddl.append(",");
                }
                String primaryKeys = columns.stream().filter(MetaColumnInfo::isPrimaryKey).map(MetaColumnInfo::getName).collect(Collectors.joining(", "));
                if (StringUtils.isNotBlank((CharSequence)primaryKeys)) {
                    ddl.append(String.format("\n\tPRIMARY KEY (%s),", primaryKeys));
                }
                ddl.deleteCharAt(ddl.length() - 1);
            }
        }
        catch (Exception e) {
            LOG.warn("Fail to get Sql columns(\u83b7\u53d6\u5b57\u6bb5\u5217\u8868\u5931\u8d25)", (Throwable)e);
        }
        ddl.append("\n)");
        return ddl.toString();
    }

    public void closeResource(Connection connection, Statement statement, ResultSet resultSet) {
        try {
            if (null != resultSet && !resultSet.isClosed()) {
                resultSet.close();
            }
            if (null != statement && !statement.isClosed()) {
                statement.close();
            }
            if (null != connection && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Fail to release resource [" + e.getMessage() + "]", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.closeResource(this.conn, null, null);
    }

    public static class ConnectMessage {
        public String host;
        public Integer port;
        public String username;
        public String password;
        public Map<String, Object> extraParams;

        public ConnectMessage(String host, Integer port, String username, String password, Map<String, Object> extraParams) {
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
            this.extraParams = extraParams;
        }
    }
}

