/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.imexport;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.linkis.engineplugin.spark.imexport.CsvRelation$;
import org.apache.linkis.engineplugin.spark.imexport.LoadData$;
import org.apache.linkis.engineplugin.spark.imexport.util.ImExportUtils$;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\tUd\u0001\u0002\u0017.\u0001iB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%I!\u0012\u0005\t/\u0002\u0011\t\u0011)A\u0005\r\")A\f\u0001C\u0001;\"9\u0011\r\u0001b\u0001\n\u0003\u0011\u0007BB2\u0001A\u0003%\u0011\u000bC\u0004e\u0001\t\u0007I\u0011\u00012\t\r\u0015\u0004\u0001\u0015!\u0003R\u0011\u001d1\u0007A1A\u0005\u0002\tDaa\u001a\u0001!\u0002\u0013\t\u0006b\u00025\u0001\u0005\u0004%\tA\u0019\u0005\u0007S\u0002\u0001\u000b\u0011B)\t\u000f)\u0004\u0001\u0019!C\u0001W\"91\u000f\u0001a\u0001\n\u0003!\bB\u0002>\u0001A\u0003&A\u000eC\u0004|\u0001\t\u0007I\u0011\u00012\t\rq\u0004\u0001\u0015!\u0003R\u0011\u001di\bA1A\u0005\u0002\tDaA \u0001!\u0002\u0013\t\u0006\u0002C@\u0001\u0005\u0004%\t!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%\t!!\u0004\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u001fAq!!\b\u0001\t\u0003\ty\u0002C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0006bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003kDqAa\u0002\u0001\t\u0003\u0011I\u0001C\u0005\u0003\u001a\u0001\t\n\u0011\"\u0001\u0003\u001c!I!\u0011\u0007\u0001\u0012\u0002\u0013\u0005!1\u0004\u0005\b\u0005g\u0001A\u0011\u0001B\u001b\u000f\u001d\u0011Y$\fE\u0001\u0005{1a\u0001L\u0017\t\u0002\t}\u0002B\u0002/$\t\u0003\u0011\t\u0005C\u0004\u0003\b\r\"\tAa\u0011\t\u0013\te1%%A\u0005\u0002\tm\u0001\"\u0003B\u0019GE\u0005I\u0011\u0001B\u000e\u0011%\u0011\u0019fII\u0001\n\u0003\u0011)\u0006C\u0004\u0003Z\r\"\tAa\u0017\t\u0013\t%4%%A\u0005\u0002\tU\u0003\"\u0003B6G\u0005\u0005I\u0011\u0002B7\u0005-\u00195O\u001e*fY\u0006$\u0018n\u001c8\u000b\u00059z\u0013\u0001C5nKb\u0004xN\u001d;\u000b\u0005A\n\u0014!B:qCJ\\'B\u0001\u001a4\u00031)gnZ5oKBdWoZ5o\u0015\t!T'\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003m]\na!\u00199bG\",'\"\u0001\u001d\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Y\u0014\t\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0004B]f\u0014VM\u001a\t\u0003y\tK!aQ\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rM|WO]2f+\u00051\u0005\u0003B$O#Rs!\u0001\u0013'\u0011\u0005%kT\"\u0001&\u000b\u0005-K\u0014A\u0002\u001fs_>$h(\u0003\u0002N{\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\u00075\u000b\u0007O\u0003\u0002N{A\u0011qIU\u0005\u0003'B\u0013aa\u0015;sS:<\u0007C\u0001\u001fV\u0013\t1VHA\u0002B]f\fqa]8ve\u000e,\u0007\u0005\u000b\u0002\u00033B\u0011AHW\u0005\u00037v\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\rqJg.\u001b;?)\tq\u0006\r\u0005\u0002`\u00015\tQ\u0006C\u0003E\u0007\u0001\u0007a)\u0001\bgS\u0016dG\rR3mS6LG/\u001a:\u0016\u0003E\u000bqBZ5fY\u0012$U\r\\5nSR,'\u000fI\u0001\tK:\u001cw\u000eZ5oO\u0006IQM\\2pI&tw\rI\u0001\n]VdGNV1mk\u0016\f!B\\;mYZ\u000bG.^3!\u0003!q\u0017M\u001c,bYV,\u0017!\u00038b]Z\u000bG.^3!\u0003=)\u0007\u0010]8si:+H\u000e\u001c,bYV,W#\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018\u0001\u00027b]\u001eT\u0011!]\u0001\u0005U\u00064\u0018-\u0003\u0002T]\u0006\u0019R\r\u001f9peRtU\u000f\u001c7WC2,Xm\u0018\u0013fcR\u0011Q\u000f\u001f\t\u0003yYL!a^\u001f\u0003\tUs\u0017\u000e\u001e\u0005\bs6\t\t\u00111\u0001m\u0003\rAH%M\u0001\u0011Kb\u0004xN\u001d;Ok2dg+\u00197vK\u0002\nQ!];pi\u0016\fa!];pi\u0016\u0004\u0013AB3tG\u0006\u0004X-A\u0004fg\u000e\f\u0007/\u001a\u0011\u0002\u0019\u0015\u001c8-\u00199f#V|G/Z:\u0016\u0005\u0005\r\u0001c\u0001\u001f\u0002\u0006%\u0019\u0011qA\u001f\u0003\u000f\t{w\u000e\\3b]\u0006iQm]2ba\u0016\fVo\u001c;fg\u0002\nq\u0002^5nKN$\u0018-\u001c9G_Jl\u0017\r^\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+\u0001\u0018\u0001\u0002;fqRLA!!\u0007\u0002\u0014\t\u00012+[7qY\u0016$\u0015\r^3G_Jl\u0017\r^\u0001\u0011i&lWm\u001d;b[B4uN]7bi\u0002\n\u0001\u0002\u001e:b]N4WM\u001d\u000b\t\u0003C\ty#a\u000f\u0002@A)\u00111EA\u0016#6\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#A\u0002sI\u0012T!\u0001M\u001b\n\t\u00055\u0012Q\u0005\u0002\u0004%\u0012#\u0005bBA\u0019/\u0001\u0007\u00111G\u0001\u0003g\u000e\u0004B!!\u000e\u000285\u0011\u0011\u0011F\u0005\u0005\u0003s\tIC\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0003\u0004\u0002>]\u0001\r!U\u0001\u0005a\u0006$\b\u000eC\u0003e/\u0001\u0007\u0011+\u0001\bdgZ$v\u000eR1uC\u001a\u0013\u0018-\\3\u0015\u0019\u0005\u0015\u0013qMA9\u0003\u0003\u000b))a\"\u0011\t\u0005\u001d\u0013\u0011\r\b\u0005\u0003\u0013\nYF\u0004\u0003\u0002L\u0005]c\u0002BA'\u0003+rA!a\u0014\u0002T9\u0019\u0011*!\u0015\n\u0003aJ!AN\u001c\n\u0005A*\u0014\u0002BA-\u0003S\t1a]9m\u0013\u0011\ti&a\u0018\u0002\u000fA\f7m[1hK*!\u0011\u0011LA\u0015\u0013\u0011\t\u0019'!\u001a\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002BA/\u0003?Ba\u0001\r\rA\u0002\u0005%\u0004\u0003BA6\u0003[j!!a\u0018\n\t\u0005=\u0014q\f\u0002\r'B\f'o[*fgNLwN\u001c\u0005\b\u0003gB\u0002\u0019AA;\u0003\u0019\u00198\r[3nCB!\u0011qOA?\u001b\t\tIH\u0003\u0003\u0002|\u0005}\u0013!\u0002;za\u0016\u001c\u0018\u0002BA@\u0003s\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\t\u0019\t\u0007a\u0001\u0003\u0007\t\u0011\u0002[1t\u0011\u0016\fG-\u001a:\t\r\u0005u\u0002\u00041\u0001R\u0011\u001d\tI\t\u0007a\u0001\u0003\u0017\u000bqaY8mk6t7\u000fE\u0003\u0002\u000e\u0006UeI\u0004\u0003\u0002\u0010\u0006MebA%\u0002\u0012&\ta(C\u0002\u0002^uJA!a&\u0002\u001a\n!A*[:u\u0015\r\ti&P\u0001\rM&dG/\u001a:D_2,XN\u001c\u000b\t\u0003?\u000b)+!+\u00026B!A(!)R\u0013\r\t\u0019+\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007\u0003OK\u0002\u0019A)\u0002\u0007I|w\u000fC\u0004\u0002,f\u0001\r!!,\u0002\r%tG-\u001a=t!\u0015a\u0014\u0011UAX!\ra\u0014\u0011W\u0005\u0004\u0003gk$aA%oi\")\u0011-\u0007a\u0001#\u0006!r-\u001a;GS2$XM]\"pYVlg.\u00138eKb$\"\"!,\u0002<\u0006u\u0016qXAa\u0011\u001d\t9C\u0007a\u0001\u0003CAQ!\u0019\u000eA\u0002ECq!!#\u001b\u0001\u0004\tY\tC\u0004\u0002\u0004j\u0001\r!a\u0001\u0002\u0013\t,\u0018\u000e\u001c3TG\u0006tG\u0003CAd\u0003\u001f\f).a6\u0011\r\u0005\r\u00121FAe!\u0011\tY'a3\n\t\u00055\u0017q\f\u0002\u0004%><\bbBAi7\u0001\u0007\u00111[\u0001\ti>\\WM\u001c*eIB1\u00111EA\u0016\u0003?Cq!a\u001d\u001c\u0001\u0004\t)\bC\u0004\u0002\nn\u0001\r!a#\u0002\r\r\f7\u000f\u001e+p)%!\u0016Q\\Aq\u0003W\fy\u000f\u0003\u0004\u0002`r\u0001\r!U\u0001\u0006M&,G\u000e\u001a\u0005\b\u0003Gd\u0002\u0019AAs\u0003!!\u0017\r^1UsB,\u0007\u0003BA<\u0003OLA!!;\u0002z\tAA)\u0019;b)f\u0004X\rC\u0004\u0002nr\u0001\r!a\u0004\u0002\u0017\u0011\fG/\u001a$pe6\fG\u000f\u0015\u0005\b\u0003cd\u0002\u0019AA\b\u0003A!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$\b+\u0001\u0007tiJLgn\u001a+p)&lW\r\u0006\u0003\u0002x\n\r\u0001\u0003BA}\u0003\u007fl!!a?\u000b\u0007\u0005u\b/\u0001\u0003vi&d\u0017\u0002\u0002B\u0001\u0003w\u0014A\u0001R1uK\"1!QA\u000fA\u0002E\u000b\u0011a]\u0001\fg\u00064X\r\u0012$U_\u000e\u001bh\u000f\u0006\u0007\u0002\u0004\t-!Q\u0002B\t\u0005'\u0011)\u0002\u0003\u00041=\u0001\u0007\u0011\u0011\u000e\u0005\b\u0005\u001fq\u0002\u0019AA#\u0003\t!g\r\u0003\u0004\u0002>y\u0001\r!\u0015\u0005\n\u0003\u0007s\u0002\u0013!a\u0001\u0003\u0007A\u0011Ba\u0006\u001f!\u0003\u0005\r!a\u0001\u0002\u0017%\u001cxJ^3soJLG/Z\u0001\u0016g\u00064X\r\u0012$U_\u000e\u001bh\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iB\u000b\u0003\u0002\u0004\t}1F\u0001B\u0011!\u0011\u0011\u0019C!\f\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0005S\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t-R(\u0001\u0006b]:|G/\u0019;j_:LAAa\f\u0003&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+M\fg/\u001a#G)>\u001c5O\u001e\u0013eK\u001a\fW\u000f\u001c;%k\u00059q-\u001a;MS:,G#B)\u00038\te\u0002bBA:C\u0001\u0007\u0011Q\u000f\u0005\b\u0003O\u000b\u0003\u0019AAe\u0003-\u00195O\u001e*fY\u0006$\u0018n\u001c8\u0011\u0005}\u001b3cA\u0012<\u0003R\u0011!Q\b\u000b\u000f\u0003\u0007\u0011)Ea\u0012\u0003J\t-#Q\nB(\u0011\u0019\u0001T\u00051\u0001\u0002j!9!qB\u0013A\u0002\u0005\u0015\u0003BBA\u001fK\u0001\u0007\u0011\u000bC\u0005\u0002\u0004\u0016\u0002\n\u00111\u0001\u0002\u0004!I!qC\u0013\u0011\u0002\u0003\u0007\u00111\u0001\u0005\t\u0005#*\u0003\u0013!a\u0001\r\u00061q\u000e\u001d;j_:\fQc]1wK\u00123Ek\\\"tm\u0012\"WMZ1vYR$c'\u0006\u0002\u0003X)\u001aaIa\b\u0002\u000f\r\u001ch\u000fV8E\rRq\u0011Q\tB/\u0005?\u0012\tGa\u0019\u0003f\t\u001d\u0004B\u0002\u0019*\u0001\u0004\tI\u0007C\u0004\u0002t%\u0002\r!!\u001e\t\u000f\u0005\r\u0015\u00061\u0001\u0002\u0004!1\u0011QH\u0015A\u0002ECq\u0001R\u0015\u0011\u0002\u0003\u0007a\tC\u0004\u0002\n&\u0002\r!a#\u0002#\r\u001ch\u000fV8E\r\u0012\"WMZ1vYR$S'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B8!\ri'\u0011O\u0005\u0004\u0005gr'AB(cU\u0016\u001cG\u000f")
public class CsvRelation
implements scala.Serializable {
    private final transient Map<String, Object> source;
    private final String fieldDelimiter;
    private final String encoding;
    private final String nullValue;
    private final String nanValue;
    private String exportNullValue;
    private final String quote;
    private final String escape;
    private final boolean escapeQuotes;
    private final SimpleDateFormat timestampFormat;

    public static Map<String, Object> csvToDF$default$5() {
        return CsvRelation$.MODULE$.csvToDF$default$5();
    }

    public static Dataset<Row> csvToDF(SparkSession sparkSession, StructType structType, boolean bl, String string, Map<String, Object> map, List<Map<String, Object>> list) {
        return CsvRelation$.MODULE$.csvToDF(sparkSession, structType, bl, string, map, list);
    }

    public static Map<String, Object> saveDFToCsv$default$6() {
        return CsvRelation$.MODULE$.saveDFToCsv$default$6();
    }

    private Map<String, Object> source() {
        return this.source;
    }

    public String fieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String encoding() {
        return this.encoding;
    }

    public String nullValue() {
        return this.nullValue;
    }

    public String nanValue() {
        return this.nanValue;
    }

    public String exportNullValue() {
        return this.exportNullValue;
    }

    public void exportNullValue_$eq(String x$1) {
        this.exportNullValue = x$1;
    }

    public String quote() {
        return this.quote;
    }

    public String escape() {
        return this.escape;
    }

    public boolean escapeQuotes() {
        return this.escapeQuotes;
    }

    public SimpleDateFormat timestampFormat() {
        return this.timestampFormat;
    }

    public RDD<String> transfer(SparkContext sc, String path, String encoding) {
        return sc.hadoopFile(path, TextInputFormat.class, LongWritable.class, Text.class, 1).map((Function1 & Serializable & scala.Serializable)p -> new String(((Text)p._2()).getBytes(), 0, ((Text)p._2()).getLength(), encoding), ClassTag$.MODULE$.apply(String.class));
    }

    public Dataset<Row> csvToDataFrame(SparkSession spark, StructType schema, boolean hasHeader, String path, List<Map<String, Object>> columns) {
        RDD<String> rdd = "utf-8".equalsIgnoreCase(this.encoding()) ? spark.sparkContext().textFile(path, spark.sparkContext().textFile$default$2()) : this.transfer(spark.sparkContext(), path, this.encoding());
        int[] indexs = this.getFilterColumnIndex(rdd, this.fieldDelimiter(), columns, hasHeader);
        RDD tokenRdd = hasHeader ? rdd.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(index, iter) -> CsvRelation.$anonfun$csvToDataFrame$1(BoxesRunTime.unboxToInt((Object)index), iter), rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(String.class)).map((Function1 & Serializable & scala.Serializable)row -> this.filterColumn((String)row, indexs, this.fieldDelimiter()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))) : rdd.map((Function1 & Serializable & scala.Serializable)row -> this.filterColumn((String)row, indexs, this.fieldDelimiter()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        RDD<Row> rowRdd = this.buildScan((RDD<String[]>)tokenRdd, schema, columns);
        return spark.createDataFrame(rowRdd, schema);
    }

    public String[] filterColumn(String row, int[] indexs, String fieldDelimiter) {
        String[] data = row.split(fieldDelimiter);
        int[] nArray = Predef$.MODULE$.intArrayOps(indexs);
        return (String[])((TraversableOnce)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data)).indices().filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)CsvRelation.$anonfun$filterColumn$1(nArray, elem)))).map((Function1)Predef$.MODULE$.wrapRefArray((Object[])data), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public int[] getFilterColumnIndex(RDD<String> rdd, String fieldDelimiter, List<Map<String, Object>> columns, boolean hasHeader) {
        return (int[])((TraversableOnce)columns.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)CsvRelation.$anonfun$getFilterColumnIndex$1(x$1)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public RDD<Row> buildScan(RDD<String[]> tokenRdd, StructType schema, List<Map<String, Object>> columns) {
        return tokenRdd.map((Function1 & Serializable & scala.Serializable)att -> {
            ArrayBuffer row = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            schema.indices().foreach((Function1 & Serializable & scala.Serializable)i -> CsvRelation.$anonfun$buildScan$2(this, att, schema, columns, row, BoxesRunTime.unboxToInt((Object)i)));
            return Row$.MODULE$.fromSeq((Seq)row);
        }, ClassTag$.MODULE$.apply(Row.class));
    }

    public Object castTo(String field, DataType dataType, SimpleDateFormat dateFormatP, SimpleDateFormat timestampFormatP) {
        String value = this.escapeQuotes() ? field.substring(1, field.length() - 1) : field;
        DataType dataType2 = dataType;
        if (dataType2 instanceof ByteType) {
            return BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(value)).toByte());
        }
        if (dataType2 instanceof ShortType) {
            return BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(value)).toShort());
        }
        if (dataType2 instanceof IntegerType) {
            return BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(value)).toInt());
        }
        if (dataType2 instanceof LongType) {
            return BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(value)).toLong());
        }
        if (dataType2 instanceof FloatType) {
            return BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(value)).toFloat());
        }
        if (dataType2 instanceof DoubleType) {
            return BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(value)).toDouble());
        }
        if (dataType2 instanceof BooleanType) {
            return BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(value)).toBoolean());
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            BigDecimal dataum = new BigDecimal(value.replaceAll(",", ""));
            return Decimal$.MODULE$.apply(dataum, decimalType.precision(), decimalType.scale());
        }
        if (dataType2 instanceof TimestampType) {
            return new Timestamp(BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.timestampFormat().parse(value).getTime()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.stringToTime(value).getTime() * 1000L)));
        }
        if (dataType2 instanceof DateType) {
            return new Date(BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> dateFormatP.parse(value).getTime()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.stringToTime(value).getTime())));
        }
        if (dataType2 instanceof StringType) {
            return value.replaceAll("\n|\t", " ");
        }
        throw new RuntimeException(new java.lang.StringBuilder(26).append("Unsupported cast from ").append(value).append(" to ").append(dataType2).toString());
    }

    public java.util.Date stringToTime(String s) {
        int indexOfGMT = s.indexOf("GMT");
        if (indexOfGMT != -1) {
            String s0 = s.substring(0, indexOfGMT);
            String s1 = s.substring(indexOfGMT + 3);
            return this.stringToTime(new java.lang.StringBuilder(0).append(s0).append(s1).toString());
        }
        if (!new StringOps(Predef$.MODULE$.augmentString(s)).contains((Object)BoxesRunTime.boxToCharacter((char)'T'))) {
            if (new StringOps(Predef$.MODULE$.augmentString(s)).contains((Object)BoxesRunTime.boxToCharacter((char)' '))) {
                return Timestamp.valueOf(s);
            }
            return Date.valueOf(s);
        }
        return DatatypeConverter.parseDateTime((String)s).getTime();
    }

    public boolean saveDFToCsv(SparkSession spark, Dataset<Row> df, String path, boolean hasHeader, boolean isOverwrite) {
        BufferedOutputStream bufferedOutputStream;
        BoxedUnit boxedUnit;
        Path filesystemPath = new Path(path);
        spark.sparkContext().hadoopConfiguration().setBoolean("fs.hdfs.impl.disable.cache", true);
        FileSystem fs = filesystemPath.getFileSystem(spark.sparkContext().hadoopConfiguration());
        fs.setVerifyChecksum(false);
        fs.setWriteChecksum(false);
        try {
            boxedUnit = fs.listFiles(filesystemPath.getParent(), false);
        }
        catch (Throwable e) {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (fs.exists(filesystemPath)) {
            if (isOverwrite) {
                bufferedOutputStream = new BufferedOutputStream((OutputStream)fs.create(filesystemPath, isOverwrite));
            } else {
                BufferedOutputStream bufferedOutputStream2 = path.startsWith("file:") ? new BufferedOutputStream(new FileOutputStream(path.substring("file://".length()), true)) : new BufferedOutputStream((OutputStream)fs.append(filesystemPath));
                bufferedOutputStream2.write("\n".getBytes(this.encoding()));
                bufferedOutputStream = bufferedOutputStream2;
            }
        } else {
            bufferedOutputStream = new BufferedOutputStream((OutputStream)fs.create(filesystemPath, isOverwrite));
        }
        BufferedOutputStream out = bufferedOutputStream;
        java.util.Iterator iterator = (java.util.Iterator)ImExportUtils$.MODULE$.tryAndThrowError((Function0 & Serializable & scala.Serializable)() -> df.toLocalIterator(), (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$2 -> {
            CsvRelation.$anonfun$saveDFToCsv$2(spark, x$2);
            return BoxedUnit.UNIT;
        });
        try {
            StructType schema = df.schema();
            StringBuilder header = new StringBuilder();
            int index = 0;
            schema.foreach((Function1 & Serializable & scala.Serializable)col -> header.$plus$plus$eq((String)new StringOps(Predef$.MODULE$.augmentString(col.name())).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(this.fieldDelimiter())), Predef$.MODULE$.StringCanBuildFrom())));
            if (hasHeader) {
                out.write(header.substring(0, header.lastIndexOf(this.fieldDelimiter())).getBytes(this.encoding()));
            } else if (iterator.hasNext()) {
                out.write(this.getLine(schema, (Row)iterator.next()).getBytes(this.encoding()));
                ++index;
            }
            while (index < Integer.MAX_VALUE && iterator.hasNext()) {
                String msg = new java.lang.StringBuilder(1).append("\n").append(this.getLine(schema, (Row)iterator.next())).toString();
                out.write(msg.getBytes(this.encoding()));
                ++index;
            }
        }
        finally {
            spark.sparkContext().clearJobGroup();
            IOUtils.closeStream((Closeable)out);
            fs.close();
        }
        return true;
    }

    public boolean saveDFToCsv$default$4() {
        return true;
    }

    public boolean saveDFToCsv$default$5() {
        return false;
    }

    public String getLine(StructType schema, Row row) {
        StringBuilder msg = new StringBuilder();
        schema.indices().foreach((Function1 & Serializable & scala.Serializable)i -> CsvRelation.$anonfun$getLine$1(this, row, msg, BoxesRunTime.unboxToInt((Object)i)));
        return msg.substring(0, msg.lastIndexOf(this.fieldDelimiter()));
    }

    public static final /* synthetic */ Iterator $anonfun$csvToDataFrame$1(int index, Iterator iter) {
        if (index == 0) {
            return iter.drop(1);
        }
        return iter;
    }

    public static final /* synthetic */ boolean $anonfun$filterColumn$1(int[] eta$0$1$1, Object elem) {
        return new ArrayOps.ofInt(eta$0$1$1).contains(elem);
    }

    public static final /* synthetic */ int $anonfun$getFilterColumnIndex$1(Map x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.getOrElse((Object)"index", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0).toString())).toInt();
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$buildScan$2(CsvRelation $this, String[] att$1, StructType schema$1, List columns$1, ArrayBuffer row$1, int i) {
        Object object;
        String field;
        String string = field = Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> att$1[i]).isDefined() ? att$1[i] : "null";
        if ($this.nanValue().equalsIgnoreCase(field)) {
            object = null;
        } else {
            DataType dataType = schema$1.apply(i).dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if ((dataType == null ? stringType$ != null : !dataType.equals(stringType$)) && (field.isEmpty() || $this.nullValue().equals(field))) {
                object = null;
            } else {
                String dateFormat = ((MapLike)columns$1.apply(i)).getOrElse((Object)"dateFormat", (Function0 & Serializable & scala.Serializable)() -> "yyyy-MM-dd").toString();
                SimpleDateFormat format = new SimpleDateFormat(dateFormat, Locale.US);
                object = $this.castTo(field, schema$1.apply(i).dataType(), format, null);
            }
        }
        Object data = object;
        return row$1.$plus$eq(data);
    }

    public static final /* synthetic */ void $anonfun$saveDFToCsv$2(SparkSession spark$1, Throwable x$2) {
        spark$1.sparkContext().clearJobGroup();
    }

    public static final /* synthetic */ StringBuilder $anonfun$getLine$1(CsvRelation $this, Row row$2, StringBuilder msg$1, int i) {
        String string;
        Object object = row$2.apply(i);
        if (object instanceof String) {
            String string2 = (String)object;
            string = ("NULL".equals(string2) || "".equals(string2)) && !"SHUFFLEOFF".equals($this.exportNullValue()) ? $this.exportNullValue() : string2.replaceAll("\n|\t", " ");
        } else if (object instanceof Object) {
            Object object2 = object;
            string = object2.toString();
        } else {
            string = "SHUFFLEOFF".equals($this.exportNullValue()) ? "NULL" : $this.exportNullValue();
        }
        String data = string;
        msg$1.append(data);
        return msg$1.append($this.fieldDelimiter());
    }

    public CsvRelation(Map<String, Object> source) {
        String string;
        this.source = source;
        this.fieldDelimiter = LoadData$.MODULE$.getMapValue(source, "fieldDelimiter", "\t");
        this.encoding = LoadData$.MODULE$.getMapValue(source, "encoding", "utf-8");
        this.nullValue = LoadData$.MODULE$.getMapValue(source, "nullValue", " ");
        this.nanValue = LoadData$.MODULE$.getMapValue(source, "nanValue", "null");
        String string2 = LoadData$.MODULE$.getMapValue(source, "exportNullValue", "SHUFFLEOFF");
        if ("BLANK".equals(string2)) {
            string = "";
        } else if (string2 != null) {
            String string3;
            string = string3 = string2;
        } else {
            throw new MatchError((Object)string2);
        }
        this.exportNullValue = string;
        this.quote = LoadData$.MODULE$.getMapValue(source, "quote", "\"");
        this.escape = LoadData$.MODULE$.getMapValue(source, "escape", "\\");
        this.escapeQuotes = BoxesRunTime.unboxToBoolean((Object)LoadData$.MODULE$.getMapValue(source, "escapeQuotes", BoxesRunTime.boxToBoolean((boolean)false)));
        this.timestampFormat = new SimpleDateFormat(LoadData$.MODULE$.getMapValue(source, "timestampFormat", "yyyy-mm-dd hh:mm:ss"), Locale.US);
    }
}

