/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.common;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.job.JobStatus;
import org.apache.linkis.cli.application.operator.once.LinkisNodeStatus;

public enum LinkisJobStatus implements JobStatus
{
    UNSUBMITTED("Unsubmitted", 0),
    SUBMITTING("Submitting", 1),
    INITED("Inited", 2),
    WAIT_FOR_RETRY("WaitForRetry", 3),
    SCHEDULED("Scheduled", 4),
    RUNNING("Running", 5),
    SUCCEED("Succeed", 6),
    FAILED("Failed", 7),
    CANCELLED("Cancelled", 8),
    TIMEOUT("Timeout", 9),
    UNKNOWN("Unknown", 10),
    SHUTTINGDOWN("Shuttingdown", 11);

    private String name;
    private int id;

    private LinkisJobStatus(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public static LinkisJobStatus convertFromJobStatusString(String status) {
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (INITED.name().equalsIgnoreCase(status)) {
                return INITED;
            }
            if (WAIT_FOR_RETRY.name().equalsIgnoreCase(status)) {
                return WAIT_FOR_RETRY;
            }
            if (SCHEDULED.name().equalsIgnoreCase(status)) {
                return SCHEDULED;
            }
            if (RUNNING.name().equalsIgnoreCase(status)) {
                return RUNNING;
            }
            if (SUCCEED.name().equalsIgnoreCase(status)) {
                return SUCCEED;
            }
            if (FAILED.name().equalsIgnoreCase(status)) {
                return FAILED;
            }
            if (CANCELLED.name().equalsIgnoreCase(status)) {
                return CANCELLED;
            }
            if (TIMEOUT.name().equalsIgnoreCase(status)) {
                return TIMEOUT;
            }
            return UNKNOWN;
        }
        return UNKNOWN;
    }

    public static LinkisJobStatus convertFromNodeStatusString(String status) {
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (LinkisNodeStatus.Idle.name().equalsIgnoreCase(status)) {
                return RUNNING;
            }
            if (LinkisNodeStatus.Starting.name().equalsIgnoreCase(status)) {
                return SCHEDULED;
            }
            if (LinkisNodeStatus.Unlock.name().equalsIgnoreCase(status)) {
                return RUNNING;
            }
            if (LinkisNodeStatus.Locked.name().equalsIgnoreCase(status)) {
                return RUNNING;
            }
            if (LinkisNodeStatus.Running.name().equalsIgnoreCase(status)) {
                return RUNNING;
            }
            if (LinkisNodeStatus.Busy.name().equalsIgnoreCase(status)) {
                return RUNNING;
            }
            if (LinkisNodeStatus.Success.name().equalsIgnoreCase(status)) {
                return SUCCEED;
            }
            if (LinkisNodeStatus.Failed.name().equalsIgnoreCase(status)) {
                return FAILED;
            }
            if (LinkisNodeStatus.ShuttingDown.name().equalsIgnoreCase(status)) {
                return SHUTTINGDOWN;
            }
            return UNKNOWN;
        }
        return UNKNOWN;
    }

    @Override
    public final boolean isJobSubmitted() {
        return this != UNSUBMITTED && this != SUBMITTING && this != UNKNOWN;
    }

    @Override
    public final boolean isJobFinishedState() {
        return this.isJobSuccess() || this.isJobFailure() || this.isJobCancelled() || this.isJobTimeout() || this.isJobAbnormalStatus() || this == SHUTTINGDOWN;
    }

    @Override
    public final boolean isJobSuccess() {
        return this == SUCCEED;
    }

    @Override
    public final boolean isJobFailure() {
        return this == FAILED;
    }

    @Override
    public final boolean isJobCancelled() {
        return this == CANCELLED;
    }

    @Override
    public final boolean isJobTimeout() {
        return this == TIMEOUT;
    }

    @Override
    public final boolean isJobAbnormalStatus() {
        return this == UNKNOWN;
    }
}

