/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.governance.common.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.governance.common.entity.job.OnceExecutorContent;
import org.apache.linkis.governance.common.exception.GovernanceErrorException;
import org.apache.linkis.governance.common.utils.OnceExecutorContentUtils;
import org.apache.linkis.governance.common.utils.OnceExecutorContentUtils$BmlResource$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class OnceExecutorContentUtils$ {
    public static OnceExecutorContentUtils$ MODULE$;
    private final String ONCE_EXECUTOR_CONTENT_KEY;
    private final String HEADER;
    private final int LEN;

    static {
        new OnceExecutorContentUtils$();
    }

    public String ONCE_EXECUTOR_CONTENT_KEY() {
        return this.ONCE_EXECUTOR_CONTENT_KEY;
    }

    private String HEADER() {
        return this.HEADER;
    }

    private int LEN() {
        return this.LEN;
    }

    public String resourceToValue(OnceExecutorContentUtils.BmlResource bmlResource) {
        String resourceId = bmlResource.getResourceId();
        int resourceIdLength = Integer.toString(resourceId.length()).length();
        if (resourceIdLength > this.LEN()) {
            throw new GovernanceErrorException(40108, new StringBuilder(38).append("Invalid resourceId ").append(resourceId).append(", it is too length.").toString());
        }
        BoxedUnit len = resourceIdLength < this.LEN() ? new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("0")).$times(this.LEN() - resourceIdLength)).append(resourceId.length()).toString() : BoxedUnit.UNIT;
        return new StringBuilder(0).append(this.HEADER()).append(len).append(resourceId).append(bmlResource.getVersion()).toString();
    }

    public OnceExecutorContentUtils.BmlResource valueToResource(String resource) {
        if (!resource.startsWith(this.HEADER())) {
            throw new GovernanceErrorException(40108, new StringBuilder(39).append("Invalid resource ").append(resource).append(", it doesn't contain ").append(this.HEADER()).append(".").toString());
        }
        String value = resource.substring(this.HEADER().length());
        String len = value.substring(0, this.LEN());
        String resourceId = value.substring(this.LEN(), new StringOps(Predef$.MODULE$.augmentString(len)).toInt() + this.LEN());
        String version = value.substring(new StringOps(Predef$.MODULE$.augmentString(len)).toInt() + this.LEN());
        return OnceExecutorContentUtils$BmlResource$.MODULE$.apply(resourceId, version);
    }

    public OnceExecutorContent mapToContent(Map<String, Object> contentMap) {
        OnceExecutorContent onceExecutorContent = new OnceExecutorContent();
        onceExecutorContent.setJobContent(OnceExecutorContentUtils$.getOrNull$1("jobContent", contentMap));
        onceExecutorContent.setRuntimeMap(OnceExecutorContentUtils$.getOrNull$1("runtime", contentMap));
        onceExecutorContent.setSourceMap(OnceExecutorContentUtils$.getOrNull$1("source", contentMap));
        onceExecutorContent.setVariableMap(OnceExecutorContentUtils$.getOrNull$1("variable", contentMap));
        return onceExecutorContent;
    }

    public Map<String, Object> contentToMap(OnceExecutorContent onceExecutorContent) {
        HashMap<String, Object> contentMap = new HashMap<String, Object>();
        contentMap.put("jobContent", onceExecutorContent.getJobContent());
        contentMap.put("runtime", onceExecutorContent.getRuntimeMap());
        contentMap.put("source", onceExecutorContent.getSourceMap());
        contentMap.put("variable", onceExecutorContent.getVariableMap());
        return contentMap;
    }

    private static final Map getOrNull$1(String key, Map contentMap$1) {
        Object v = contentMap$1.get(key);
        if (v instanceof Map) {
            Map map = (Map)v;
            return map;
        }
        return null;
    }

    private OnceExecutorContentUtils$() {
        MODULE$ = this;
        this.ONCE_EXECUTOR_CONTENT_KEY = "onceExecutorContent";
        this.HEADER = "resource_";
        this.LEN = 3;
    }
}

