/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.partition;

import java.util.List;
import org.apache.kafka.server.partition.AssignmentState;

public record OngoingReassignmentState(List<Integer> addingReplicas, List<Integer> removingReplicas, List<Integer> replicas) implements AssignmentState
{
    public OngoingReassignmentState {
        addingReplicas = List.copyOf(addingReplicas);
        removingReplicas = List.copyOf(removingReplicas);
        replicas = List.copyOf(replicas);
    }

    @Override
    public int replicationFactor() {
        return (int)this.replicas.stream().filter(r -> !this.addingReplicas.contains(r)).count();
    }

    @Override
    public boolean isAddingReplica(int brokerId) {
        return this.addingReplicas.contains(brokerId);
    }
}

