/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.AbstractFetcherManager;
import kafka.server.BrokerBlockingSender;
import kafka.server.KafkaConfig;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.network.BrokerEndPoint;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000514A\u0001D\u0007\u0001%!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0005 \u0011!\u0019\u0003A!A!\u0002\u0013\u0001\u0003\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u0011E\u0002!\u0011!Q\u0001\nIB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0011\n\u0001B\u0001B\u0003%!\nC\u0003O\u0001\u0011\u0005q\nC\u0003Y\u0001\u0011\u0005\u0013\fC\u0003h\u0001\u0011\u0005\u0001NA\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u000b\u00059y\u0011AB:feZ,'OC\u0001\u0011\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\n\u0011\u0007Q)r#D\u0001\u000e\u0013\t1RB\u0001\fBEN$(/Y2u\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s!\t!\u0002$\u0003\u0002\u001a\u001b\t!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"\u0001\u0006\u000f\n\u0005ui!aC&bM.\f7i\u001c8gS\u001e\faB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001!!\t!\u0012%\u0003\u0002#\u001b\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u000f5,GO]5dgB\u0011aeL\u0007\u0002O)\u0011A\u0005\u000b\u0006\u0003S)\naaY8n[>t'B\u0001\t,\u0015\taS&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0005\u0019qN]4\n\u0005A:#aB'fiJL7m]\u0001\u0005i&lW\r\u0005\u00024m5\tAG\u0003\u00026Q\u0005)Q\u000f^5mg&\u0011q\u0007\u000e\u0002\u0005)&lW-\u0001\u0007rk>$\u0018-T1oC\u001e,'\u000f\u0005\u0002\u0015u%\u00111(\u0004\u0002\u0018%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJ\fq#\\3uC\u0012\fG/\u0019,feNLwN\\*vaBd\u0017.\u001a:\u0011\u0007y\n5)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002E\u000f6\tQI\u0003\u0002*\r*\u0011aBK\u0005\u0003\u0011\u0016\u0013q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u0014EJ|7.\u001a:Fa>\u001c\u0007nU;qa2LWM\u001d\t\u0004}\u0005[\u0005C\u0001 M\u0013\tiuH\u0001\u0003M_:<\u0017A\u0002\u001fj]&$h\b\u0006\u0005Q#J\u001bF+\u0016,X!\t!\u0002\u0001C\u0003\u001b\u0013\u0001\u00071\u0004C\u0003\u001f\u0013\u0001\u0007\u0001\u0005C\u0003%\u0013\u0001\u0007Q\u0005C\u00032\u0013\u0001\u0007!\u0007C\u00039\u0013\u0001\u0007\u0011\bC\u0003=\u0013\u0001\u0007Q\bC\u0003J\u0013\u0001\u0007!*A\nde\u0016\fG/\u001a$fi\u000eDWM\u001d+ie\u0016\fG\rF\u0002\u00185~CQa\u0017\u0006A\u0002q\u000b\u0011BZ3uG\",'/\u00133\u0011\u0005yj\u0016B\u00010@\u0005\rIe\u000e\u001e\u0005\u0006A*\u0001\r!Y\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\u001a\u000bqA\\3uo>\u00148.\u0003\u0002gG\nq!I]8lKJ,e\u000e\u001a)pS:$\u0018\u0001C:ikR$wn\u001e8\u0015\u0003%\u0004\"A\u00106\n\u0005-|$\u0001B+oSR\u0004")
public class ReplicaFetcherManager
extends AbstractFetcherManager<ReplicaFetcherThread> {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final Metrics metrics;
    private final Time time;
    private final ReplicationQuotaManager quotaManager;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Function0<Object> brokerEpochSupplier;

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
        String threadName = "ReplicaFetcherThread-" + fetcherId + "-" + sourceBroker.id();
        LogContext logContext = new LogContext("[ReplicaFetcher replicaId=" + this.brokerConfig.brokerId() + ", leaderId=" + sourceBroker.id() + ", fetcherId=" + fetcherId + "] ");
        BrokerBlockingSender endpoint = new BrokerBlockingSender(sourceBroker, this.brokerConfig, this.metrics, this.time, fetcherId, "broker-" + this.brokerConfig.brokerId() + "-fetcher-" + fetcherId, logContext);
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, sourceBroker.id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), endpoint, fetchSessionHandler, this.brokerConfig, this.replicaManager(), this.quotaManager, this.metadataVersionSupplier, this.brokerEpochSupplier);
        return new ReplicaFetcherThread(threadName, leader, this.brokerConfig, this.failedPartitions(), this.replicaManager(), this.quotaManager, logContext.logPrefix());
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.closeAllFetchers();
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutdown completed");
    }

    public ReplicaFetcherManager(KafkaConfig brokerConfig, ReplicaManager replicaManager, Metrics metrics, Time time, ReplicationQuotaManager quotaManager, Function0<MetadataVersion> metadataVersionSupplier, Function0<Object> brokerEpochSupplier) {
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.metrics = metrics;
        this.time = time;
        this.quotaManager = quotaManager;
        this.metadataVersionSupplier = metadataVersionSupplier;
        this.brokerEpochSupplier = brokerEpochSupplier;
        super("ReplicaFetcherManager on broker " + brokerConfig.brokerId(), "Replica", brokerConfig.numReplicaFetchers());
    }
}

