/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.InvalidRegularExpression;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.transaction.TransactionMetadata;
import org.apache.kafka.coordinator.transaction.TransactionState;
import org.apache.kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r-e\u0001\u0002\u001c8\u0001yB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"AQ\f\u0001B\u0001B\u0003%a\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0011!Q\u0007A!A!\u0002\u0013Y\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011]\u0004!\u0011!Q\u0001\naDQ! \u0001\u0005\u0002y,a!a\u0004\u0001\t\u0005E\u0001\"CA\u001e\u0001\t\u0007I\u0011BA\u001f\u0011!\t)\u0006\u0001Q\u0001\n\u0005}\u0002\"CA,\u0001\t\u0007I\u0011BA-\u0011!\t9\u0007\u0001Q\u0001\n\u0005m\u0003BCA5\u0001\t\u0007I\u0011A\u001c\u0002l!A\u00111\u0011\u0001!\u0002\u0013\ti\u0007\u0003\u0006\u0002\u0006\u0002\u0011\r\u0011\"\u00018\u0003\u000fC\u0001\"!&\u0001A\u0003%\u0011\u0011\u0012\u0005\f\u0003/\u0003\u0001\u0019!a\u0001\n\u0013\tI\nC\u0006\u0002\"\u0002\u0001\r\u00111A\u0005\n\u0005\r\u0006bCAU\u0001\u0001\u0007\t\u0011)Q\u0005\u00037C1\"a+\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002.\"Y\u0011q\u0016\u0001A\u0002\u0003\u0007I\u0011BAY\u0011)\t)\f\u0001a\u0001\u0002\u0003\u0006K\u0001\u0014\u0005\n\u0003\u007f\u0003!\u0019!C\u0005\u0003\u0003D\u0001\"!3\u0001A\u0003%\u00111\u0019\u0005\t\u0003\u0017\u0004A\u0011A\u001c\u0002N\"A\u0011\u0011\u001c\u0001\u0005\u0002]\nY\u000e\u0003\u0005\u0002d\u0002!\taNAs\u0011\u001d\ty\u000f\u0001C\u0001\u0003cDqA!\u0005\u0001\t\u0013\u0011\u0019\u0002C\u0004\u0003&\u0001!IAa\n\t\u000f\t]\u0002\u0001\"\u0003\u0003:!A!\u0011\u0003\u0001\u0005\u0002]\u0012y\u0005C\u0004\u0003R\u0001!IAa\u0015\t\u000f\t5\u0004\u0001\"\u0001\u0003P!9!q\u000e\u0001\u0005\u0002\tE\u0004b\u0002BS\u0001\u0011\u0005!q\u0015\u0005\b\u0005[\u0003A\u0011\u0001BX\u0011\u001d\u0011\u0019\u000e\u0001C\u0005\u0005+DqAa8\u0001\t\u0003\u0011\t\u000fC\u0004\u0003l\u0002!\tA!<\t\u000f\t]\b\u0001\"\u0001\u0003z\"9!Q \u0001\u0005\n\t}\b\u0002CB\b\u0001\u0011\u0005qg!\u0005\t\u000f\ru\u0001\u0001\"\u0001\u0004 !91Q\u0006\u0001\u0005\u0002\r=\u0002bBB\u0017\u0001\u0011\u000511\u0007\u0005\b\u0007s\u0001A\u0011BB\u001e\u0011\u001d\u0019\t\u0005\u0001C\u0005\u0005\u001fBqaa\u0011\u0001\t\u0003\u0019)\u0005C\u0005\u0004j\u0001\t\n\u0011\"\u0001\u0004l!91\u0011\u0011\u0001\u0005\u0002\r\r\u0005bBBE\u0001\u0011\u0005!q\n\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJT!\u0001O\u001d\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003um\n1bY8pe\u0012Lg.\u0019;pe*\tA(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001yT\t\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015I\u0001\u0004B]f\u0014VM\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011n\nQ!\u001e;jYNL!AS$\u0003\u000f1{wmZ5oO\u0006A!M]8lKJLE\r\u0005\u0002A\u001b&\u0011a*\u0011\u0002\u0004\u0013:$\u0018!C:dQ\u0016$W\u000f\\3s!\t\t6,D\u0001S\u0015\t\u0019F+\u0001\u0003vi&d'BA+W\u0003\u0019\u0019XM\u001d<fe*\u0011Ah\u0016\u0006\u00031f\u000ba!\u00199bG\",'\"\u0001.\u0002\u0007=\u0014x-\u0003\u0002]%\nI1k\u00195fIVdWM]\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\ty\u0016-D\u0001a\u0015\t)6(\u0003\u0002cA\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002fQ6\taM\u0003\u0002h-\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0002jM\niQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\faaY8oM&<\u0007C\u00017n\u001b\u00059\u0014B\u000188\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\u0005i&lW\r\u0005\u0002rk6\t!O\u0003\u0002Ig*\u0011AOV\u0001\u0007G>lWn\u001c8\n\u0005Y\u0014(\u0001\u0002+j[\u0016\fq!\\3ue&\u001c7\u000f\u0005\u0002zw6\t!P\u0003\u0002xg&\u0011AP\u001f\u0002\b\u001b\u0016$(/[2t\u0003\u0019a\u0014N\\5u}Qyq0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti\u0001\u0005\u0002m\u0001!)1\n\u0003a\u0001\u0019\")q\n\u0003a\u0001!\")Q\f\u0003a\u0001=\")1\r\u0003a\u0001I\")!\u000e\u0003a\u0001W\")q\u000e\u0003a\u0001a\")q\u000f\u0003a\u0001q\n12+\u001a8e)btW*\u0019:lKJ\u001c8)\u00197mE\u0006\u001c7\u000e\u0005\u0007A\u0003'a\u0015qCA\u0012\u0003_\t)$C\u0002\u0002\u0016\u0005\u0013\u0011BR;oGRLwN\u001c\u001b\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\bt\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u0011\u00037\u0011\u0011\u0003\u0016:b]N\f7\r^5p]J+7/\u001e7u!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"b\u0001\u001d\u0002*)\u0011!HV\u0005\u0005\u0003[\t9CA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\u0005\u0003\u0002&\u0005E\u0012\u0002BA\u001a\u0003O\u0011!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uCB\u0019\u0001)a\u000e\n\u0007\u0005e\u0012I\u0001\u0003V]&$\u0018\u0001D:ikR$\u0018N\\4E_^tWCAA !\u0011\t\t%!\u0015\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\na!\u0019;p[&\u001c'\u0002BA%\u0003\u0017\n!bY8oGV\u0014(/\u001a8u\u0015\r\u0019\u0016Q\n\u0006\u0003\u0003\u001f\nAA[1wC&!\u00111KA\"\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006i1\u000f[;ui&tw\rR8x]\u0002\n\u0011b\u001d;bi\u0016dunY6\u0016\u0005\u0005m\u0003\u0003BA/\u0003Gj!!a\u0018\u000b\t\u0005\u0005\u0014qI\u0001\u0006Y>\u001c7n]\u0005\u0005\u0003K\nyF\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0003)\u0019H/\u0019;f\u0019>\u001c7\u000eI\u0001\u0012Y>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:\u001cXCAA7!\u0019\ty'!\u001f\u0002~5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n)(A\u0004nkR\f'\r\\3\u000b\u0007\u0005]\u0014)\u0001\u0006d_2dWm\u0019;j_:LA!a\u001f\u0002r\t\u00191+\u001a;\u0011\u00071\fy(C\u0002\u0002\u0002^\u0012!\u0005\u0016:b]N\f7\r^5p]B\u000b'\u000f^5uS>t\u0017I\u001c3MK\u0006$WM]#q_\u000eD\u0017A\u00057pC\u0012Lgn\u001a)beRLG/[8og\u0002\n\u0001\u0004\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006\u001c\u0015m\u00195f+\t\tI\tE\u0004\u0002p\u0005-E*a$\n\t\u00055\u0015\u0011\u000f\u0002\u0004\u001b\u0006\u0004\bc\u00017\u0002\u0012&\u0019\u00111S\u001c\u0003+QCh.T3uC\u0012\fG/Y\"bG\",WI\u001c;ss\u0006IBO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003\u0019\u0012X\r\u001e:jKZ,GK]1og\u0006\u001cG/[8o)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e^\u000b\u0003\u00037\u0003B\u0001QAO\u0019&\u0019\u0011qT!\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014A\u000b:fiJLWM^3Ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi~#S-\u001d\u000b\u0005\u0003k\t)\u000bC\u0005\u0002(N\t\t\u00111\u0001\u0002\u001c\u0006\u0019\u0001\u0010J\u0019\u0002OI,GO]5fm\u0016$&/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG\u000fI\u0001\u001fiJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R,\u0012\u0001T\u0001#iJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R|F%Z9\u0015\t\u0005U\u00121\u0017\u0005\t\u0003O3\u0012\u0011!a\u0001\u0019\u0006yBO]1og\u0006\u001cG/[8o)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e\u001e\u0011)\u0007]\tI\fE\u0002A\u0003wK1!!0B\u0005!1x\u000e\\1uS2,\u0017a\u00059beRLG/[8o\u0019>\fGmU3og>\u0014XCAAb!\rI\u0018QY\u0005\u0004\u0003\u000fT(AB*f]N|'/\u0001\u000bqCJ$\u0018\u000e^5p]2{\u0017\rZ*f]N|'\u000fI\u0001\u0018iJ\fgn]1di&|gNV3sg&|g\u000eT3wK2$\"!a4\u0011\t\u0005E\u0017Q[\u0007\u0003\u0003'T!\u0001\u001e+\n\t\u0005]\u00171\u001b\u0002\u0013)J\fgn]1di&|gNV3sg&|g.A\fjgR\u0013\u0018M\\:bGRLwN\u001c\u001aqG\u0016s\u0017M\u00197fIR\u0011\u0011Q\u001c\t\u0004\u0001\u0006}\u0017bAAq\u0003\n9!i\\8mK\u0006t\u0017aE1eI2{\u0017\rZ5oOB\u000b'\u000f^5uS>tGCBA\u001b\u0003O\fY\u000f\u0003\u0004\u0002jr\u0001\r\u0001T\u0001\fa\u0006\u0014H/\u001b;j_:LE\r\u0003\u0004\u0002nr\u0001\r\u0001T\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"\fA\u0003^5nK\u0012|U\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001cHCAAz!\u0019\t)P!\u0002\u0003\f9!\u0011q\u001fB\u0001\u001d\u0011\tI0a@\u000e\u0005\u0005m(bAA\u007f{\u00051AH]8pizJ\u0011AQ\u0005\u0004\u0005\u0007\t\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005\u000f\u0011IA\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011\u0019!\u0011\t\u0004Y\n5\u0011b\u0001B\bo\t\tCK]1og\u0006\u001cG/[8oC2LE-\u00118e!J|G-^2fe&#W\t]8dQ\u0006i\"/Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000f\u0006\u0004\u00026\tU!\u0011\u0005\u0005\b\u0005/q\u0002\u0019\u0001B\r\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8QCJ$\u0018\u000e^5p]B!!1\u0004B\u000f\u001b\u0005\u0019\u0018b\u0001B\u0010g\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B\u0012=\u0001\u0007\u0011qR\u0001\u0016ibtW*\u001a;bI\u0006$\u0018mQ1dQ\u0016,e\u000e\u001e:z\u00031\u0019\bn\\;mI\u0016C\b/\u001b:f)\u0019\tiN!\u000b\u0003.!9!1F\u0010A\u0002\u0005\r\u0012a\u0003;y]6+G/\u00193bi\u0006DqAa\f \u0001\u0004\u0011\t$A\u0007dkJ\u0014XM\u001c;US6,Wj\u001d\t\u0004\u0001\nM\u0012b\u0001B\u001b\u0003\n!Aj\u001c8h\u0003Ui\u0017-\u001f2f\u0003B\u0004XM\u001c3FqBL'/\u0019;j_:$\u0002\"!8\u0003<\tu\"Q\n\u0005\b\u0005W\u0001\u0003\u0019AA\u0012\u0011\u001d\u0011y\u0004\ta\u0001\u0005\u0003\naB]3d_J$7OQ;jY\u0012,'\u000f\u0005\u0003\u0003D\t%SB\u0001B#\u0015\r\u00119e]\u0001\u0007e\u0016\u001cwN\u001d3\n\t\t-#Q\t\u0002\u0015\u001b\u0016lwN]=SK\u000e|'\u000fZ:Ck&dG-\u001a:\t\u000f\t=\u0002\u00051\u0001\u00032Q\u0011\u0011QG\u0001*oJLG/\u001a+p[\n\u001cHo\u001c8fg\u001a{'/\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:\u0015\u0011\u0005U\"Q\u000bB,\u0005GBqAa\u0006#\u0001\u0004\u0011I\u0002C\u0004\u0003Z\t\u0002\rAa\u0017\u0002'\u0015D\b/\u001b:fI\u001a{'\u000fU1si&$\u0018n\u001c8\u0011\r\u0005U(Q\u0001B/!\ra'qL\u0005\u0004\u0005C:$A\u000b+sC:\u001c\u0018m\u0019;j_:\fG.\u00133D_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006sG-T3uC\u0012\fG/\u0019\u0005\b\u0005K\u0012\u0003\u0019\u0001B4\u0003A!x.\u001c2ti>tWMU3d_J$7\u000f\u0005\u0003\u0003D\t%\u0014\u0002\u0002B6\u0005\u000b\u0012Q\"T3n_JL(+Z2pe\u0012\u001c\u0018aH3oC\ndW\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]\u0006\u0019r-\u001a;Ue\u0006t7/Y2uS>t7\u000b^1uKR!!1\u000fBI!!\t)P!\u001e\u0003z\t\u0015\u0015\u0002\u0002B<\u0005\u0013\u0011a!R5uQ\u0016\u0014\b\u0003\u0002B>\u0005\u0003k!A! \u000b\u0007\t}4/\u0001\u0005qe>$xnY8m\u0013\u0011\u0011\u0019I! \u0003\r\u0015\u0013(o\u001c:t!\u0015\u0001%q\u0011BF\u0013\r\u0011I)\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00071\u0014i)C\u0002\u0003\u0010^\u0012adQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195B]\u0012$\u0006P\\'fi\u0006$\u0017\r^1\t\u000f\tME\u00051\u0001\u0003\u0016\u0006yAO]1og\u0006\u001cG/[8oC2LE\r\u0005\u0003\u0003\u0018\n}e\u0002\u0002BM\u00057\u00032!!?B\u0013\r\u0011i*Q\u0001\u0007!J,G-\u001a4\n\t\t\u0005&1\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\tu\u0015)\u0001\u0010qkR$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-\u00134O_R,\u00050[:ugR!!\u0011\u0016BV!!\t)P!\u001e\u0003z\t-\u0005b\u0002B\u0016K\u0001\u0007\u00111E\u0001\u0016Y&\u001cH\u000f\u0016:b]N\f7\r^5p]N#\u0018\r^3t))\u0011\tL!0\u0003F\n-'q\u001a\t\u0005\u0005g\u0013I,\u0004\u0002\u00036*\u0019!qW:\u0002\u000f5,7o]1hK&!!1\u0018B[\u0005qa\u0015n\u001d;Ue\u0006t7/Y2uS>t7OU3ta>t7/\u001a#bi\u0006DqAa0'\u0001\u0004\u0011\t-A\tgS2$XM\u001d)s_\u0012,8-\u001a:JIN\u0004bAa&\u0003D\nE\u0012\u0002BA>\u0005GCqAa2'\u0001\u0004\u0011I-\u0001\tgS2$XM]*uCR,g*Y7fgB1!q\u0013Bb\u0005+CqA!4'\u0001\u0004\u0011\t$\u0001\tgS2$XM\u001d#ve\u0006$\u0018n\u001c8Ng\"9!\u0011\u001b\u0014A\u0002\tU\u0015\u0001\b4jYR,'\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\n\u001a)biR,'O\\\u0001\u001fO\u0016$\u0018I\u001c3NCf\u0014W-\u00113e)J\fgn]1di&|gn\u0015;bi\u0016$bAa\u001d\u0003X\ne\u0007b\u0002BJO\u0001\u0007!Q\u0013\u0005\b\u00057<\u0003\u0019\u0001Bo\u0003U\u0019'/Z1uK\u0012$\u0006P\\'fi\u0006$\u0017\r^1PaR\u0004R\u0001\u0011BD\u0003G\tAD^1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000f\u0006\u0004\u0002^\n\r(q\u001d\u0005\b\u0005KD\u0003\u0019AAo\u0003-)g.\u00192mKR;x\u000eU\"\t\r\t%\b\u00061\u0001M\u00031!\bP\u001c+j[\u0016|W\u000f^'t\u0003]!(/\u00198tC\u000e$\u0018n\u001c8U_BL7mQ8oM&<7/\u0006\u0002\u0003pB!!\u0011\u001fBz\u001b\t\tY%\u0003\u0003\u0003v\u0006-#A\u0003)s_B,'\u000f^5fg\u0006a\u0001/\u0019:uSRLwN\u001c$peR\u0019AJa?\t\u000f\tM%\u00061\u0001\u0003\u0016\u00069Bn\\1e)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u000b\u0007\u0007\u0003\u0019Ia!\u0004\u0011\u0011\r\r1Q\u0001BK\u0003Gi!!a\u0012\n\t\r\u001d\u0011q\t\u0002\u000e\u0007>t7-\u001e:sK:$X*\u00199\t\u000f\r-1\u00061\u0001\u0003\u001a\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007BBAwW\u0001\u0007A*\u0001\u000fbI\u0012du.\u00193fIR\u0013\u0018M\\:bGRLwN\\:U_\u000e\u000b7\r[3\u0015\u0011\u0005U21CB\f\u00073Aaa!\u0006-\u0001\u0004a\u0015!\u0005;y]R{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0011Q\u001e\u0017A\u00021Cqaa\u0007-\u0001\u0004\u0019\t!\u0001\nm_\u0006$W\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\u0018\u0001\n7pC\u0012$&/\u00198tC\u000e$\u0018n\u001c8t\r>\u0014H\u000b\u001f8U_BL7\rU1si&$\u0018n\u001c8\u0015\u0011\u0005U2\u0011EB\u0012\u0007KAa!!;.\u0001\u0004a\u0005BBAw[\u0001\u0007A\nC\u0004\u0004(5\u0002\ra!\u000b\u0002\u001dM,g\u000e\u001a+y]6\u000b'o[3sgB\u001911F\u0005\u000e\u0003\u0001\taE]3n_Z,GK]1og\u0006\u001cG/[8og\u001a{'\u000f\u0016=o)>\u0004\u0018n\u0019)beRLG/[8o)\u0011\t)d!\r\t\r\u0005%h\u00061\u0001M)\u0019\t)d!\u000e\u00048!1\u0011\u0011^\u0018A\u00021Ca!!<0\u0001\u0004a\u0015a\b:f[>4X\rT8bI&tw\rU1si&$\u0018n\u001c8XSRDW\t]8dQR1\u0011QGB\u001f\u0007\u007fAa!!;1\u0001\u0004a\u0005BBAwa\u0001\u0007A*\u0001\u0018wC2LG-\u0019;f)J\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]RL5o\u0015;bE2,\u0017AF1qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4\u0015\u001d\u0005U2qIB%\u0007\u0017\u001aye!\u0017\u0004`!9!1\u0013\u001aA\u0002\tU\u0005BBAwe\u0001\u0007A\nC\u0004\u0004NI\u0002\r!a\f\u0002\u00179,w/T3uC\u0012\fG/\u0019\u0005\b\u0007#\u0012\u0004\u0019AB*\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0004A\u0007+\u0012I(!\u000e\n\u0007\r]\u0013IA\u0005Gk:\u001cG/[8oc!I11\f\u001a\u0011\u0002\u0003\u00071QL\u0001\re\u0016$(/_(o\u000bJ\u0014xN\u001d\t\b\u0001\u000eU#\u0011PAo\u0011\u001d\u0019\tG\ra\u0001\u0007G\nAB]3rk\u0016\u001cH\u000fT8dC2\u0004B!!5\u0004f%!1qMAj\u00051\u0011V-];fgRdunY1m\u0003\u0001\n\u0007\u000f]3oIR\u0013\u0018M\\:bGRLwN\u001c+p\u0019><G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r5$\u0006BB/\u0007_Z#a!\u001d\u0011\t\rM4QP\u0007\u0003\u0007kRAaa\u001e\u0004z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007w\n\u0015AC1o]>$\u0018\r^5p]&!1qPB;\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\bgR\f'\u000f^;q)\u0019\t)d!\"\u0004\b\"9\u0011q\u0013\u001bA\u0002\u0005m\u0005b\u0002B7i\u0001\u0007\u0011Q\\\u0001\tg\",H\u000fZ8x]\u0002")
public class TransactionStateManager
implements Logging {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final MetadataCache metadataCache;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private Function0<Object> retrieveTransactionTopicPartitionCount;
    private volatile int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private Function0<Object> retrieveTransactionTopicPartitionCount() {
        return this.retrieveTransactionTopicPartitionCount;
    }

    private void retrieveTransactionTopicPartitionCount_$eq(Function0<Object> x$1) {
        this.retrieveTransactionTopicPartitionCount = x$1;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private void transactionTopicPartitionCount_$eq(int x$1) {
        this.transactionTopicPartitionCount = x$1;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    public TransactionVersion transactionVersionLevel() {
        short fromFeatureLevel_version = Predef$.MODULE$.Short2short(this.metadataCache.features().finalizedFeatures().getOrDefault("transaction.version", Predef$.MODULE$.short2Short((short)0)));
        return (TransactionVersion)Feature.TRANSACTION_VERSION.fromFeatureLevel(fromFeatureLevel_version, true);
    }

    public boolean isTransaction2pcEnabled() {
        return this.config.transaction2PCEnable();
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        scala.collection.mutable.Iterable iterable;
        long now = this.time.milliseconds();
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    private void removeExpiredTransactionalIds(TopicPartition transactionPartition, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$1(this, transactionPartition, txnMetadataCacheEntry);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private boolean shouldExpire(TransactionMetadata txnMetadata, long currentTimeMs) {
        return txnMetadata.state().isExpirationAllowed() && txnMetadata.txnLastUpdateTimestamp() <= currentTimeMs - (long)this.config.transactionalIdExpirationMs();
    }

    private boolean maybeAppendExpiration(TransactionMetadata txnMetadata, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(txnMetadata.transactionalId());
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    public void removeExpiredTransactionalIds() {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$4(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void writeTombstonesForExpiredTransactionalIds(TopicPartition transactionPartition, Iterable<TransactionalIdCoordinatorEpochAndMetadata> expiredForPartition, MemoryRecords tombstoneRecords) {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$8(this, transactionPartition, tombstoneRecords, expiredForPartition);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", () -> this.removeExpiredTransactionalIds(), (long)this.config.removeExpiredTransactionalIdsIntervalMs(), (long)this.config.removeExpiredTransactionalIdsIntervalMs());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata)).map((Function1 & Serializable)x$3 -> (CoordinatorEpochAndTxnMetadata)x$3.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Unexpected empty transaction metadata returned while putting " + txnMetadata);
        }));
    }

    public ListTransactionsResponseData listTransactionStates(scala.collection.immutable.Set<Object> filterProducerIds, scala.collection.immutable.Set<String> filterStateNames, long filterDurationMs, String filterTransactionalIdPattern) {
        ListTransactionsResponseData listTransactionsResponseData;
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            listTransactionsResponseData = TransactionStateManager.$anonfun$listTransactionStates$1(this, filterStateNames, filterProducerIds, filterDurationMs, filterTransactionalIdPattern);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return listTransactionsResponseData;
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(boolean enableTwoPC, int txnTimeoutMs) {
        return enableTwoPC || txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    public Properties transactionTopicConfigs() {
        Properties props = new Properties();
        props.put("unclean.leader.election.enable", "false");
        props.put("compression.type", BrokerCompressionType.UNCOMPRESSED.name);
        props.put("cleanup.policy", "compact");
        props.put("min.insync.replicas", Integer.toString(this.config.transactionLogMinInsyncReplicas()));
        props.put("segment.bytes", Integer.toString(this.config.transactionLogSegmentBytes()));
        return props;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private ConcurrentMap<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        ConcurrentHashMap<String, TransactionMetadata> loadedTransactions = new ConcurrentHashMap<String, TransactionMetadata>();
        Option<UnifiedLog> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Attempted to load transaction metadata from " + topicPartition + ", but found no log");
        } else if (option instanceof Some) {
            UnifiedLog log = (UnifiedLog)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    Lock inReadLock_inLock_lock = this.stateLock().readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    Object var15_14 = null;
                    Object var16_15 = null;
                    if (!bl) break;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchIsolation.LOG_END, true);
                    readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                    Records records = fetchDataInfo.records;
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable)() -> "Loaded transaction metadata from " + topicPartition + " with buffer larger (" + bytesNeeded + " bytes) than configured transaction.state.log.load.buffer.size (" + $this.config.transactionLogLoadBufferSize() + " bytes)");
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    memoryRecords.batches().forEach(batch -> {
                        CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                            Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable)() -> "Transaction state log's key should not be null");
                            Either<Object, String> either = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
                            if (either instanceof Left) {
                                short version = BoxesRunTime.unboxToShort((Object)((Left)either).value());
                                this.warn((Function0<String>)(Function0 & Serializable)() -> "Unknown message key with version " + version + " while loading transaction state from " + topicPartition + ". Ignoring it. It could be a left over from an aborted upgrade.");
                                return BoxedUnit.UNIT;
                            }
                            if (either instanceof Right) {
                                String transactionalId = (String)((Right)either).value();
                                Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
                                if (None$.MODULE$.equals(option)) {
                                    return (TransactionMetadata)loadedTransactions.remove(transactionalId);
                                }
                                if (option instanceof Some) {
                                    TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
                                    return loadedTransactions.put(transactionalId, txnMetadata);
                                }
                                throw new MatchError(option);
                            }
                            throw new MatchError(either);
                        });
                        currOffset$1.elem = batch.nextOffset();
                    });
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Error loading transactions from transaction log " + topicPartition, (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, ConcurrentMap<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry).foreach((Function1 & Serializable)previousTxnMetadataCacheEntry -> {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Unloaded transaction metadata " + previousTxnMetadataCacheEntry + " from " + txnTopicPartition$1 + " as part of loading metadata at epoch " + coordinatorEpoch$2);
            return BoxedUnit.UNIT;
        });
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var8_6 = null;
        long scheduleStartMs = this.time.milliseconds();
        this.scheduler.scheduleOnce("load-txns-for-partition-" + topicPartition, () -> this.loadTransactions$1(Predef$.MODULE$.long2Long(scheduleStartMs), topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, partitionId, sendTxnMarkers));
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionId, coordinatorEpoch, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void removeLoadingPartitionWithEpoch(int partitionId, int coordinatorEpoch) {
        this.loadingPartitions().find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeLoadingPartitionWithEpoch$1(partitionId, x$9))).foreach((Function1 & Serializable)partitionAndLeaderEpoch -> {
            TransactionStateManager.$anonfun$removeLoadingPartitionWithEpoch$2(this, coordinatorEpoch, partitionAndLeaderEpoch);
            return BoxedUnit.UNIT;
        });
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount;
        int previouslyDeterminedPartitionCount = this.transactionTopicPartitionCount();
        if (previouslyDeterminedPartitionCount != (curTransactionTopicPartitionCount = this.retrieveTransactionTopicPartitionCount().apply$mcI$sp())) {
            throw new KafkaException("Transaction topic number of partitions has changed from " + previouslyDeterminedPartitionCount + " to " + curTransactionTopicPartitionCount);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError, RequestLocal requestLocal) {
        keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata, this.transactionVersionLevel());
        timestamp = this.time.milliseconds();
        var18_10 = new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)};
        withRecords_compression = TransactionLog$.MODULE$.EnforcedCompression();
        withRecords_magic = 2;
        var22_13 = TimestampType.CREATE_TIME;
        withRecords_initialOffset = 0L;
        var22_13 = null;
        var17_11 = null;
        var18_10 = null;
        records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        transactionStateTopicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        transactionStateTopicIdPartition = this.replicaManager.topicIdPartition(transactionStateTopicPartition);
        recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionStateTopicIdPartition), (Object)records)}));
        inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            block10: {
                block9: {
                    var23_20 = false;
                    var24_21 = null;
                    var25_22 = this.getTransactionState(transactionalId);
                    if (!(var25_22 instanceof Left)) break block9;
                    $anonfun$appendTransactionToLog$13_err = (Errors)((Left)var25_22).value();
                    (BoxedUnit)responseCallback.apply((Object)$anonfun$appendTransactionToLog$13_err);
                    break block10;
                }
                if (!(var25_22 instanceof Right)) ** GOTO lbl-1000
                var23_20 = true;
                var24_21 = (Right)var25_22;
                var27_24 = (Option)var24_21.value();
                if (None$.MODULE$.equals(var27_24)) {
                    (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                } else if (var23_20 && (var28_25 = (Option)var24_21.value()) instanceof Some) {
                    $anonfun$appendTransactionToLog$13_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_25).value();
                    if (BoxesRunTime.unboxToBoolean((Object)$anonfun$appendTransactionToLog$13_epochAndMetadata.transactionMetadata().inLock((Supplier<Object>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$14$adapted(kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 ), ()Ljava/lang/Object;)((CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$13_epochAndMetadata, (int)coordinatorEpoch, responseCallback)))) {
                        $anonfun$appendTransactionToLog$13_x$1 = newMetadata.txnTimeoutMs();
                        $anonfun$appendTransactionToLog$13_x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
                        $anonfun$appendTransactionToLog$13_x$6 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$appendTransactionToLog$15$adapted(kafka.coordinator.transaction.TransactionStateManager org.apache.kafka.common.TopicIdPartition org.apache.kafka.common.TopicPartition java.lang.String org.apache.kafka.coordinator.transaction.TxnTransitMetadata int scala.Function1 scala.Function1 scala.collection.Map ), (Lscala/collection/Map;)Ljava/lang/Object;)((TransactionStateManager)this, (TopicIdPartition)transactionStateTopicIdPartition, (TopicPartition)transactionStateTopicPartition, (String)transactionalId, (TxnTransitMetadata)newMetadata, (int)coordinatorEpoch, retryOnError, responseCallback);
                        $anonfun$appendTransactionToLog$13_x$8 = this.replicaManager.appendRecords$default$7();
                        $anonfun$appendTransactionToLog$13_x$9 = this.replicaManager.appendRecords$default$9();
                        $anonfun$appendTransactionToLog$13_x$10 = this.replicaManager.appendRecords$default$10();
                        this.replicaManager.appendRecords($anonfun$appendTransactionToLog$13_x$1, $anonfun$appendTransactionToLog$13_x$2, true, AppendOrigin.COORDINATOR, (Map<TopicIdPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicIdPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)$anonfun$appendTransactionToLog$13_x$6, $anonfun$appendTransactionToLog$13_x$8, requestLocal, $anonfun$appendTransactionToLog$13_x$9, $anonfun$appendTransactionToLog$13_x$10);
                        this.trace((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$16(org.apache.kafka.coordinator.transaction.TxnTransitMetadata java.lang.String int ), ()Ljava/lang/String;)((TxnTransitMetadata)newMetadata, (String)transactionalId, (int)coordinatorEpoch));
                    }
                } else {
                    throw new MatchError(var25_22);
                }
            }
            var24_21 = null;
            var25_22 = null;
            var26_23 = null;
            var27_24 = null;
            var28_25 = null;
            var29_26 = null;
            var33_29 = null;
            var34_30 = null;
            var35_31 = null;
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$10));
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.retrieveTransactionTopicPartitionCount = retrieveTransactionTopicPartitionCount;
        this.transactionTopicPartitionCount_$eq(retrieveTransactionTopicPartitionCount.apply$mcI$sp());
        if (enableTransactionalIdExpiration) {
            this.enableTransactionalIdExpiration();
            return;
        }
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                return false;
            }
            TransactionState transactionState = txnMetadata.state();
            if (TransactionState.ONGOING.equals(transactionState)) {
                return !txnMetadata.isDistributedTwoPhaseCommitTxn() && txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1;
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ scala.collection.mutable.Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (scala.collection.mutable.Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)x0$1._2();
                return (IterableOnce)((IterableOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(entry.metadataPerTransactionalId()).asScala().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$1, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                    if (x0$3 != null) {
                        String txnId = (String)x0$3._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                        return new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        });
    }

    private final void flushRecordsBuilder$1(TopicPartition transactionPartition$1, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$1(TransactionStateManager $this, TopicPartition transactionPartition$1, TxnMetadataCacheEntry txnMetadataCacheEntry$1) {
        Option<LogConfig> option = $this.replicaManager.getLogConfig(transactionPartition$1);
        if (option instanceof Some) {
            LogConfig logConfig = (LogConfig)((Some)option).value();
            long currentTimeMs = $this.time.milliseconds();
            int maxBatchSize = logConfig.maxMessageSize();
            ListBuffer expired = ListBuffer$.MODULE$.empty();
            ObjectRef recordsBuilder = ObjectRef.create(null);
            BufferedIterator stateEntries = CollectionConverters$.MODULE$.CollectionHasAsScala(txnMetadataCacheEntry$1.metadataPerTransactionalId().values()).asScala().iterator().buffered();
            while (stateEntries.hasNext()) {
                TransactionMetadata txnMetadata = (TransactionMetadata)stateEntries.head();
                String transactionalId = txnMetadata.transactionalId();
                BooleanRef fullBatch = BooleanRef.create((boolean)false);
                txnMetadata.inLock(() -> {
                    if (txnMetadata.pendingState().isEmpty() && $this.shouldExpire(txnMetadata, currentTimeMs)) {
                        if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                            recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(16384, maxBatchSize)), (Compression)TransactionLog$.MODULE$.EnforcedCompression(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)maxBatchSize);
                        }
                        if ($this.maybeAppendExpiration(txnMetadata, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                            TxnTransitMetadata transitMetadata = txnMetadata.prepareDead();
                            return expired.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, txnMetadataCacheEntry$1.coordinatorEpoch(), transitMetadata));
                        }
                        fullBatch$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                if (fullBatch.elem) {
                    $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                    expired.clear();
                    recordsBuilder.elem = null;
                    continue;
                }
                stateEntries.next();
            }
            if (expired.nonEmpty()) {
                $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                expired.clear();
                recordsBuilder.elem = null;
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> "Transaction expiration for partition " + transactionPartition$1 + " failed because the log config was not available, which likely means the partition is not online or is no longer local.");
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$5(TransactionStateManager $this, int partitionId, TxnMetadataCacheEntry partitionCacheEntry) {
        TopicPartition transactionPartition = new TopicPartition("__transaction_state", partitionId);
        $this.removeExpiredTransactionalIds(transactionPartition, partitionCacheEntry);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$4(TransactionStateManager $this) {
        $this.transactionMetadataCache().foreachEntry((Function2 & Serializable)(partitionId, partitionCacheEntry) -> {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$5($this, BoxesRunTime.unboxToInt((Object)partitionId), partitionCacheEntry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$2(TransactionStateManager $this, TopicIdPartition topicPartition$1, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1) {
        $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition())).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            expiredForPartition$1.foreach((Function1 & Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = (TransactionMetadata)txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock(() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().filter(s -> {
                        TransactionState transactionState = s;
                        TransactionState transactionState2 = TransactionState.DEAD;
                        return !(transactionState != null ? !transactionState.equals(transactionState2) : transactionState2 != null);
                    }).isPresent() && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> "Failed to remove expired transactionalId: " + transactionalId + " from cache. Tombstone append error code: " + response$1.error + ", pendingState: " + txnMetadata.pendingState() + ", producerEpoch: " + txnMetadata.producerEpoch() + ", expected producerEpoch: " + idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch() + ", coordinatorEpoch: " + txnMetadataCacheEntry.coordinatorEpoch() + ", expected coordinatorEpoch: " + idCoordinatorEpochAndMetadata.coordinatorEpoch());
                    txnMetadata.pendingState(Optional.empty());
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$1(TransactionStateManager $this, Iterable expiredForPartition$1, TopicIdPartition topicPartition, ProduceResponse.PartitionResponse response) {
        Lock inReadLock_inLock_lock = $this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$2($this, topicPartition, expiredForPartition$1, response);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        responses.foreachEntry((Function2 & Serializable)(topicPartition, response) -> {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$1(this, expiredForPartition$1, topicPartition, response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$8(TransactionStateManager $this, TopicPartition transactionPartition$2, MemoryRecords tombstoneRecords$1, Iterable expiredForPartition$1) {
        long x$1 = $this.config.requestTimeoutMs();
        short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.replicaManager.topicIdPartition(transactionPartition$2)), (Object)tombstoneRecords$1)}));
        Function1 & Serializable x$6 = (Function1 & Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, expiredForPartition$1);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$7 = RequestLocal.noCaching();
        Function1<Map<TopicIdPartition, RecordValidationStats>, BoxedUnit> x$8 = $this.replicaManager.appendRecords$default$7();
        Map<TopicPartition, VerificationGuard> x$9 = $this.replicaManager.appendRecords$default$9();
        short x$10 = $this.replicaManager.appendRecords$default$10();
        $this.replicaManager.appendRecords(x$1, x$2, true, AppendOrigin.COORDINATOR, (Map<TopicIdPartition, MemoryRecords>)x$5, (Function1<Map<TopicIdPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$7, x$9, x$10);
    }

    public static final /* synthetic */ void $anonfun$listTransactionStates$2(Set filterStates$1, ListTransactionsResponseData response$2, String stateName) {
        TransactionState.fromName((String)stateName).ifPresentOrElse(state -> filterStates$1.$plus$eq(state), () -> response$2.unknownStateFilters().add(stateName));
    }

    private static final boolean shouldInclude$1(TransactionMetadata txnMetadata, Pattern pattern, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1, long filterDurationMs$1, long now$2) {
        TransactionState transactionState = txnMetadata.state();
        TransactionState transactionState2 = TransactionState.DEAD;
        if (!(transactionState != null ? !transactionState.equals(transactionState2) : transactionState2 != null)) {
            return false;
        }
        if (filterProducerIds$1.nonEmpty() && !filterProducerIds$1.contains((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId()))) {
            return false;
        }
        if (filterStateNames$1.nonEmpty() && !filterStates$1.contains((Object)txnMetadata.state())) {
            return false;
        }
        if (filterDurationMs$1 >= 0L && now$2 - txnMetadata.txnStartTimestamp() <= filterDurationMs$1) {
            return false;
        }
        if (pattern != null) {
            return pattern.matcher((CharSequence)txnMetadata.transactionalId()).matches();
        }
        return true;
    }

    public static final /* synthetic */ void $anonfun$listTransactionStates$5(Pattern pattern$1, ArrayList states$1, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1, long filterDurationMs$1, long now$2, int x$4, TxnMetadataCacheEntry cache) {
        cache.metadataPerTransactionalId().forEach((x$5, txnMetadata) -> txnMetadata.inLock(() -> {
            if (TransactionStateManager.shouldInclude$1(txnMetadata, pattern$1, filterProducerIds$1, filterStateNames$1, filterStates$1, filterDurationMs$1, now$2)) {
                return BoxesRunTime.boxToBoolean((boolean)states$1.add(new ListTransactionsResponseData.TransactionState().setTransactionalId(txnMetadata.transactionalId()).setProducerId(txnMetadata.producerId()).setTransactionState(txnMetadata.state().stateName())));
            }
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ ListTransactionsResponseData $anonfun$listTransactionStates$1(TransactionStateManager $this, scala.collection.immutable.Set filterStateNames$1, scala.collection.immutable.Set filterProducerIds$1, long filterDurationMs$1, String filterTransactionalIdPattern$1) {
        Pattern pattern;
        ListTransactionsResponseData response = new ListTransactionsResponseData();
        if ($this.loadingPartitions().nonEmpty()) {
            return response.setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code());
        }
        Set filterStates = (Set)Set$.MODULE$.empty();
        filterStateNames$1.foreach((Function1 & Serializable)stateName -> {
            TransactionStateManager.$anonfun$listTransactionStates$2(filterStates, response, stateName);
            return BoxedUnit.UNIT;
        });
        long now = $this.time.milliseconds();
        ArrayList states = new ArrayList();
        if (filterTransactionalIdPattern$1 != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(filterTransactionalIdPattern$1))) {
            try {
                pattern = Pattern.compile((String)filterTransactionalIdPattern$1);
            }
            catch (PatternSyntaxException e) {
                throw new InvalidRegularExpression(String.format("Transaction ID pattern `%s` is not a valid regular expression: %s.", filterTransactionalIdPattern$1, e.getMessage()));
            }
        } else {
            pattern = null;
        }
        Pattern pattern2 = pattern;
        $this.transactionMetadataCache().foreachEntry((Function2 & Serializable)(x$4, cache) -> {
            TransactionStateManager.$anonfun$listTransactionStates$5(pattern2, states, filterProducerIds$1, filterStateNames$1, filterStates, filterDurationMs$1, now, BoxesRunTime.unboxToInt((Object)x$4), cache);
            return BoxedUnit.UNIT;
        });
        return response.setErrorCode(Errors.NONE.code()).setTransactionStates(states);
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$6) {
        return x$6.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$3, Option createdTxnMetadataOpt$1) {
        int partitionId = $this.partitionFor(transactionalId$3);
        if ($this.loadingPartitions().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$6)))) {
            return new Left((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option txnMetadata = Option$.MODULE$.apply(cacheEntry.metadataPerTransactionalId().get(transactionalId$3)).orElse((Function0 & Serializable)() -> createdTxnMetadataOpt$1.map((Function1 & Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfAbsent(transactionalId$3, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable)() -> createdTxnMetadata)));
            return new Right((Object)txnMetadata.map((Function1 & Serializable)x$7 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$7)));
        }
        if (None$.MODULE$.equals(option)) {
            return new Left((Object)Errors.NOT_COORDINATOR);
        }
        throw new MatchError((Object)option);
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$7(TransactionStateManager $this, int partitionId$2, Function4 sendTxnMarkers$1, TransactionalIdCoordinatorEpochAndTransitMetadata txnTransitMetadata) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> "Sending txn markers for " + txnTransitMetadata + " after loading partition " + partitionId$2);
        sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$4(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, ConcurrentMap loadedTransactions$2, int partitionId$2, Function4 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.forEach((transactionalId, txnMetadata) -> txnMetadata.inLock(() -> {
                TransactionState transactionState = txnMetadata.state();
                if (TransactionState.PREPARE_ABORT.equals(transactionState)) {
                    return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata((String)transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, (TransactionMetadata)txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                }
                if (TransactionState.PREPARE_COMMIT.equals(transactionState)) {
                    return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata((String)transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, (TransactionMetadata)txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                }
                return BoxedUnit.UNIT;
            }));
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$7(this, partitionId$2, sendTxnMarkers$1, txnTransitMetadata);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final void loadTransactions$1(Long startTimeMs, TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, int partitionId$2, Function4 sendTxnMarkers$1) {
        long schedulerTimeMs = this.time.milliseconds() - Predef$.MODULE$.Long2long(startTimeMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Loading transaction metadata from " + topicPartition$3 + " at epoch " + coordinatorEpoch$3);
        this.validateTransactionTopicPartitionCountIsStable();
        ConcurrentMap<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        long endTimeMs = this.time.milliseconds();
        long totalLoadingTimeMs = endTimeMs - Predef$.MODULE$.Long2long(startTimeMs);
        this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Finished loading " + loadedTransactions.size() + " transaction metadata from " + topicPartition$3 + " in " + totalLoadingTimeMs + " milliseconds, of which " + schedulerTimeMs + " milliseconds was spent in the scheduler.");
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            if (this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions);
                ListBuffer $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.forEach((transactionalId, txnMetadata) -> txnMetadata.inLock(() -> {
                    TransactionState transactionState = txnMetadata.state();
                    if (TransactionState.PREPARE_ABORT.equals(transactionState)) {
                        return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata((String)transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, (TransactionMetadata)txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                    }
                    if (TransactionState.PREPARE_COMMIT.equals(transactionState)) {
                        return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata((String)transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, (TransactionMetadata)txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                    }
                    return BoxedUnit.UNIT;
                }));
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                    TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$7(this, partitionId$2, sendTxnMarkers$1, txnTransitMetadata);
                    return BoxedUnit.UNIT;
                });
            }
            Object var16_12 = null;
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var14_11 = null;
        this.info((Function0<String>)(Function0 & Serializable)() -> "Completed loading transaction metadata from " + topicPartition$3 + " for coordinator epoch " + coordinatorEpoch$3);
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$3, TransactionPartitionAndLeaderEpoch x$8) {
        return x$8.txnPartitionId() == partitionId$3;
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$3, TopicPartition topicPartition$4) {
        $this.loadingPartitions().$minus$minus$eq((IterableOnce)$this.loadingPartitions().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$3, x$8))));
        $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3)).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            $this.info((Function0<String>)(Function0 & Serializable)() -> "Unloaded transaction metadata " + txnMetadataCacheEntry + " for " + topicPartition$4 + " following local partition deletion");
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, int partitionId$4, int coordinatorEpoch$4, TopicPartition topicPartition$5) {
        $this.removeLoadingPartitionWithEpoch(partitionId$4, coordinatorEpoch$4);
        Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$4));
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable)() -> "Unloaded transaction metadata " + txnMetadataCacheEntry + " for " + topicPartition$5 + " on become-follower transition");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> "No cached transaction metadata found for " + topicPartition$5 + " during become-follower transition");
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$removeLoadingPartitionWithEpoch$1(int partitionId$5, TransactionPartitionAndLeaderEpoch x$9) {
        return x$9.txnPartitionId() == partitionId$5;
    }

    public static final /* synthetic */ void $anonfun$removeLoadingPartitionWithEpoch$2(TransactionStateManager $this, int coordinatorEpoch$5, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch) {
        if (partitionAndLeaderEpoch.coordinatorEpoch() < coordinatorEpoch$5) {
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch);
            $this.info((Function0<String>)(Function0 & Serializable)() -> "Cancelling load of currently loading partition " + partitionAndLeaderEpoch);
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$5, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return "Appending " + transactionalId$5 + "'s new metadata " + newMetadata$1 + " failed due to " + status$1.error.exceptionName();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$5, Errors err$1) {
        return "Accessing the cached transaction metadata for " + transactionalId$5 + " returns " + err$1 + " error; aborting transition to the new metadata and setting the error in the callback";
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$6) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> "The cached coordinator epoch for " + transactionalId$5 + " has changed to " + epochAndMetadata$1.coordinatorEpoch() + " after appended its new metadata " + newMetadata$1 + " to the transaction log (txn topic partition " + $this.partitionFor(transactionalId$5) + ") while it was " + coordinatorEpoch$6 + " before appending; aborting transition to the new metadata and returning " + Errors.NOT_COORDINATOR + " in the callback");
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable)() -> "Updating " + transactionalId$5 + "'s transaction state to " + newMetadata$1 + " with coordinator epoch " + coordinatorEpoch$6 + " for " + transactionalId$5 + " succeeded");
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$6) {
        return "The cached coordinator metadata does not exist in the cache anymore for " + transactionalId$5 + " after appended its new metadata " + newMetadata$1 + " to the transaction log (txn topic partition " + $this.partitionFor(transactionalId$5) + ") while it was " + coordinatorEpoch$6 + " before appending; aborting transition to the new metadata and returning " + Errors.NOT_COORDINATOR + " in the callback";
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$6, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$6) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> "TransactionalId " + metadata$2.transactionalId() + " append transaction log for " + newMetadata$1 + " transition failed due to " + (Errors)responseError$1.elem + ", not resetting pending state " + metadata$2.pendingState() + " but just returning the error in the callback to let the caller retry");
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable)() -> "TransactionalId " + metadata$2.transactionalId() + " append transaction log for " + newMetadata$1 + " transition failed due to " + (Errors)responseError$1.elem + ", resetting pending state from " + metadata$2.pendingState() + ", aborting state transition and returning " + (Errors)responseError$1.elem + " in the callback");
            metadata$2.pendingState(Optional.empty());
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> "TransactionalId " + metadata$2.transactionalId() + " append transaction log for " + newMetadata$1 + " transition failed due to " + (Errors)responseError$1.elem + ", aborting state transition and returning the error in the callback since the coordinator epoch has changed from " + epochAndTxnMetadata$1.coordinatorEpoch() + " to " + coordinatorEpoch$6);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return "TransactionalId " + transactionalId$5 + " append transaction log for " + newMetadata$1 + " transition failed due to " + (Errors)responseError$1.elem + ", aborting state transition and returning the error in the callback since metadata is not available in the cache anymore";
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return "TransactionalId " + transactionalId$5 + " append transaction log for " + newMetadata$1 + " transition failed due to " + (Errors)responseError$1.elem + ", aborting state transition and returning the error in the callback since retrieving metadata returned " + error$1;
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicIdPartition transactionStateTopicIdPartition$1, TopicPartition transactionStateTopicPartition$1, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$6, Function1 retryOnError$1, Function1 responseCallback$1) {
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)transactionStateTopicIdPartition$1)) {
                                throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, transactionStateTopicPartition$1})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)transactionStateTopicIdPartition$1);
                            v0 = status.error;
                            var11_10 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var11_10) == false : var11_10 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String org.apache.kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var12_11 = status.error;
                                v1 = (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var12_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var12_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var12_11) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var12_11) != false))) != false ? Errors.COORDINATOR_NOT_AVAILABLE : ((Errors.NOT_LEADER_OR_FOLLOWER.equals(var12_11) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var12_11) != false) != false ? Errors.NOT_COORDINATOR : ((Errors.MESSAGE_TOO_LARGE.equals(var12_11) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var12_11) != false) != false ? Errors.UNKNOWN_SERVER_ERROR : var12_11));
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var13_13 = Errors.NONE;
                            if (v2 != null ? v2.equals(var13_13) == false : var13_13 != null) break block9;
                            var14_14 = false;
                            var15_15 = null;
                            var16_16 = this.getTransactionState(transactionalId$5);
                            if (!(var16_16 instanceof Left)) break block10;
                            err = (Errors)((Left)var16_16).value();
                            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)err));
                            responseError.elem = err;
                            break block11;
                        }
                        if (!(var16_16 instanceof Right)) break block12;
                        var14_14 = true;
                        var15_15 = (Right)var16_16;
                        var18_18 = (Option)var15_15.value();
                        if (!(var18_18 instanceof Some)) break block12;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var18_18).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((Supplier<Object>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$3$adapted(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String org.apache.kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.coordinator.transaction.TransactionMetadata ), ()Ljava/lang/Object;)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$6, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block11;
                    }
                    if (!var14_14 || !None$.MODULE$.equals(var21_21 = (Option)var15_15.value())) break block13;
                    this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String org.apache.kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$6));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block11;
                }
                throw new MatchError(var16_16);
            }
            var22_22 = false;
            var23_23 = null;
            var24_24 = this.getTransactionState(transactionalId$5);
            if (!(var24_24 instanceof Right)) ** GOTO lbl-1000
            var22_22 = true;
            var23_23 = (Right)var24_24;
            var25_25 = (Option)var23_23.value();
            if (var25_25 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var25_25).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((Supplier<Object>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$7$adapted(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef org.apache.kafka.coordinator.transaction.TransactionMetadata org.apache.kafka.coordinator.transaction.TxnTransitMetadata ), ()Ljava/lang/Object;)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$6, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var22_22 && None$.MODULE$.equals(var28_28 = (Option)var23_23.value())) {
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String org.apache.kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var24_24 instanceof Left) {
                error = (Errors)((Left)var24_24).value();
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String org.apache.kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var24_24);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$14(CoordinatorEpochAndTxnMetadata epochAndMetadata$2, int coordinatorEpoch$6, Function1 responseCallback$1) {
        if (epochAndMetadata$2.coordinatorEpoch() != coordinatorEpoch$6) {
            responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
            return false;
        }
        return true;
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$5, Function1 responseCallback$1, int coordinatorEpoch$6, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, RequestLocal requestLocal$1, TopicIdPartition transactionStateTopicIdPartition$1, TopicPartition transactionStateTopicPartition$1, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$5);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean((Object)epochAndMetadata.transactionMetadata().inLock(() -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$14(epochAndMetadata, coordinatorEpoch$6, responseCallback$1))))) {
                long x$1 = newMetadata$1.txnTimeoutMs();
                short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
                Function1 & Serializable x$6 = (Function1 & Serializable)responseStatus -> {
                    $this.updateCacheCallback$1(responseStatus, transactionStateTopicIdPartition$1, transactionStateTopicPartition$1, transactionalId$5, newMetadata$1, coordinatorEpoch$6, retryOnError$1, responseCallback$1);
                    return BoxedUnit.UNIT;
                };
                Function1<Map<TopicIdPartition, RecordValidationStats>, BoxedUnit> x$8 = $this.replicaManager.appendRecords$default$7();
                Map<TopicPartition, VerificationGuard> x$9 = $this.replicaManager.appendRecords$default$9();
                short x$10 = $this.replicaManager.appendRecords$default$10();
                $this.replicaManager.appendRecords(x$1, x$2, true, AppendOrigin.COORDINATOR, (Map<TopicIdPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicIdPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, requestLocal$1, x$9, x$10);
                $this.trace((Function0<String>)(Function0 & Serializable)() -> "Appending new metadata " + newMetadata$1 + " for transaction id " + transactionalId$5 + " with coordinator epoch " + coordinatorEpoch$6 + " to the local transaction log");
                return;
            }
            return;
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$10) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public TransactionStateManager(int brokerId, Scheduler scheduler, ReplicaManager replicaManager, MetadataCache metadataCache, TransactionConfig config, Time time, Metrics metrics) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        void sensor_name;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.metadataCache = metadataCache;
        this.config = config;
        this.time = time;
        this.logIdent_$eq("[Transaction State Manager " + brokerId + "]: ");
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        String string = "TransactionsPartitionLoadTime";
        if (metrics == null) {
            throw null;
        }
        Sensor.RecordingLevel sensor_recordingLevel = Sensor.RecordingLevel.INFO;
        Object var13_9 = null;
        string = null;
        this.partitionLoadSensor = metrics.sensor((String)sensor_name, null, sensor_recordingLevel, (Sensor[])null);
        Sensor sensor = this.partitionLoadSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("partition-load-time-max", "transaction-coordinator-metrics", "The max time it took to load the partitions in the last 30sec");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.partitionLoadSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("partition-load-time-avg", "transaction-coordinator-metrics", "The avg time it took to load the partitions in the last 30sec");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }

    public static final /* synthetic */ Object $anonfun$appendTransactionToLog$3$adapted(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        TransactionStateManager.$anonfun$appendTransactionToLog$3($this, epochAndMetadata$1, coordinatorEpoch$6, transactionalId$5, newMetadata$1, responseError$1, metadata$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$appendTransactionToLog$7$adapted(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$6, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        TransactionStateManager.$anonfun$appendTransactionToLog$7($this, epochAndTxnMetadata$1, coordinatorEpoch$6, retryOnError$1, responseError$1, metadata$2, newMetadata$1);
        return BoxedUnit.UNIT;
    }
}

