/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.image.node.ScramImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.ScramCredentialData;

public record ScramImage(Map<ScramMechanism, Map<String, ScramCredentialData>> mechanisms) {
    public static final ScramImage EMPTY = new ScramImage(Map.of());
    private static final String DESCRIBE_DUPLICATE_USER = "Cannot describe SCRAM credentials for the same user twice in a single request: ";
    private static final String DESCRIBE_USER_THAT_DOES_NOT_EXIST = "Attempt to describe a user credential that does not exist: ";

    public ScramImage {
        mechanisms = Collections.unmodifiableMap(mechanisms);
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        if (options.metadataVersion().isScramSupported()) {
            for (Map.Entry<ScramMechanism, Map<String, ScramCredentialData>> mechanismEntry : this.mechanisms.entrySet()) {
                for (Map.Entry<String, ScramCredentialData> userEntry : mechanismEntry.getValue().entrySet()) {
                    writer.write(0, userEntry.getValue().toRecord(userEntry.getKey(), mechanismEntry.getKey()));
                }
            }
        } else {
            boolean isEmpty = true;
            StringBuilder scramImageString = new StringBuilder("ScramImage({");
            for (Map.Entry<ScramMechanism, Map<String, ScramCredentialData>> mechanismEntry : this.mechanisms.entrySet()) {
                if (mechanismEntry.getValue().isEmpty()) continue;
                scramImageString.append(mechanismEntry.getKey()).append(":");
                ArrayList<String> users = new ArrayList<String>(mechanismEntry.getValue().keySet());
                scramImageString.append(String.join((CharSequence)", ", users));
                scramImageString.append("},{");
                isEmpty = false;
            }
            if (!isEmpty) {
                scramImageString.append("})");
                options.handleLoss(scramImageString.toString());
            }
        }
    }

    public DescribeUserScramCredentialsResponseData describe(DescribeUserScramCredentialsRequestData request) {
        List users = request.users();
        HashMap<String, Boolean> uniqueUsers = new HashMap<String, Boolean>();
        if (users == null || users.isEmpty()) {
            for (Map<String, ScramCredentialData> scramCredentialDataSet : this.mechanisms.values()) {
                for (String user : scramCredentialDataSet.keySet()) {
                    uniqueUsers.put(user, false);
                }
            }
        } else {
            for (DescribeUserScramCredentialsRequestData.UserName user : users) {
                if (uniqueUsers.containsKey(user.name())) {
                    uniqueUsers.put(user.name(), true);
                    continue;
                }
                uniqueUsers.put(user.name(), false);
            }
        }
        DescribeUserScramCredentialsResponseData retval = new DescribeUserScramCredentialsResponseData();
        for (Map.Entry user : uniqueUsers.entrySet()) {
            DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser((String)user.getKey());
            if (!((Boolean)user.getValue()).booleanValue()) {
                boolean dataFound = false;
                ArrayList<DescribeUserScramCredentialsResponseData.CredentialInfo> credentialInfos = new ArrayList<DescribeUserScramCredentialsResponseData.CredentialInfo>();
                for (Map.Entry<ScramMechanism, Map<String, ScramCredentialData>> mechanismsEntry : this.mechanisms.entrySet()) {
                    Map<String, ScramCredentialData> credentialDataSet = mechanismsEntry.getValue();
                    if (!credentialDataSet.containsKey(user.getKey())) continue;
                    credentialInfos.add(new DescribeUserScramCredentialsResponseData.CredentialInfo().setMechanism(mechanismsEntry.getKey().type()).setIterations(credentialDataSet.get(user.getKey()).iterations()));
                    dataFound = true;
                }
                if (dataFound) {
                    result.setCredentialInfos(credentialInfos);
                } else {
                    result.setErrorCode(Errors.RESOURCE_NOT_FOUND.code()).setErrorMessage(DESCRIBE_USER_THAT_DOES_NOT_EXIST + (String)user.getKey());
                }
            } else {
                result.setErrorCode(Errors.DUPLICATE_RESOURCE.code()).setErrorMessage(DESCRIBE_DUPLICATE_USER + (String)user.getKey());
            }
            retval.results().add(result);
        }
        return retval;
    }

    public boolean isEmpty() {
        return this.mechanisms.isEmpty();
    }

    @Override
    public String toString() {
        return new ScramImageNode(this).stringify();
    }
}

