/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.module.blackbird.BlackbirdModule;
import java.util.Set;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class JsonSerializer
implements Serializer<JsonNode> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonSerializer() {
        this(Set.of(), new JsonNodeFactory(true), true);
    }

    JsonSerializer(Set<SerializationFeature> serializationFeatures, JsonNodeFactory jsonNodeFactory, boolean enableBlackbird) {
        serializationFeatures.forEach(arg_0 -> ((ObjectMapper)this.objectMapper).enable(arg_0));
        this.objectMapper.setNodeFactory(jsonNodeFactory);
        if (enableBlackbird) {
            this.objectMapper.registerModule((Module)new BlackbirdModule());
        }
    }

    public byte[] serialize(String topic, JsonNode data) {
        if (data == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes((Object)data);
        }
        catch (Exception e) {
            throw new SerializationException("Error serializing JSON message", (Throwable)e);
        }
    }
}

