/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

public record SubscriptionCount(int byNameCount, int byRegexCount) {
    @Override
    public String toString() {
        return "SubscriptionCount(byNameCount=" + this.byNameCount + ", byRegexCount=" + this.byRegexCount + ")";
    }

    public static SubscriptionCount incNameCount(String key, SubscriptionCount count) {
        if (count == null) {
            return new SubscriptionCount(1, 0);
        }
        return new SubscriptionCount(count.byNameCount + 1, count.byRegexCount);
    }

    public static SubscriptionCount decNameCount(String key, SubscriptionCount count) {
        if (count == null || count.byNameCount == 1 && count.byRegexCount == 0) {
            return null;
        }
        return new SubscriptionCount(count.byNameCount - 1, count.byRegexCount);
    }

    public static SubscriptionCount incRegexCount(String key, SubscriptionCount count) {
        if (count == null) {
            return new SubscriptionCount(0, 1);
        }
        return new SubscriptionCount(count.byNameCount, count.byRegexCount + 1);
    }

    public static SubscriptionCount decRegexCount(String key, SubscriptionCount count) {
        if (count == null || count.byRegexCount == 1 && count.byNameCount == 0) {
            return null;
        }
        return new SubscriptionCount(count.byNameCount, count.byRegexCount - 1);
    }
}

