/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share.generated;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotKey;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotKeyJsonConverter;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotValue;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotValueJsonConverter;
import org.apache.kafka.coordinator.share.generated.ShareUpdateKey;
import org.apache.kafka.coordinator.share.generated.ShareUpdateKeyJsonConverter;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValue;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValueJsonConverter;

public class CoordinatorRecordJsonConverters {
    public static JsonNode writeRecordKeyAsJson(ApiMessage key) {
        switch (key.apiKey()) {
            case 0: {
                return ShareSnapshotKeyJsonConverter.write((ShareSnapshotKey)key, (short)0);
            }
            case 1: {
                return ShareUpdateKeyJsonConverter.write((ShareUpdateKey)key, (short)0);
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + key.apiKey());
    }

    public static JsonNode writeRecordValueAsJson(ApiMessage value, short version) {
        switch (value.apiKey()) {
            case 0: {
                return ShareSnapshotValueJsonConverter.write((ShareSnapshotValue)value, version);
            }
            case 1: {
                return ShareUpdateValueJsonConverter.write((ShareUpdateValue)value, version);
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + value.apiKey());
    }

    public static ApiMessage readRecordKeyFromJson(JsonNode json, short apiKey) {
        switch (apiKey) {
            case 0: {
                return ShareSnapshotKeyJsonConverter.read(json, (short)0);
            }
            case 1: {
                return ShareUpdateKeyJsonConverter.read(json, (short)0);
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + apiKey);
    }

    public static ApiMessage readRecordValueFromJson(JsonNode json, short apiKey, short version) {
        switch (apiKey) {
            case 0: {
                return ShareSnapshotValueJsonConverter.read(json, version);
            }
            case 1: {
                return ShareUpdateValueJsonConverter.read(json, version);
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + apiKey);
    }
}

