/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.io;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.CacheMode;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.FileUtils;
import org.apache.juneau.commons.utils.Utils;

public class MimeTypeDetector {
    public static final MimeTypeDetector DEFAULT = MimeTypeDetector.builder().addDefaultMappings().build();
    private final Map<String, String> extMap;
    private final Map<String, String> fileMap;
    private final Cache<String, String> cache;
    private final boolean nioContentBasedDetection;
    private final String defaultType;

    public static Builder builder() {
        return new Builder();
    }

    private MimeTypeDetector(Builder builder) {
        this.extMap = new ConcurrentHashMap<String, String>(builder.extMap);
        this.fileMap = new ConcurrentHashMap<String, String>(builder.fileMap);
        this.nioContentBasedDetection = builder.nioContentBasedDetection;
        this.defaultType = builder.defaultType;
        Cache.Builder<String, String> cacheBuilder = Cache.of(String.class, String.class).maxSize(builder.cacheSize).cacheMode(builder.cacheMode);
        if (builder.cacheLogOnExit) {
            cacheBuilder.logOnExit("MimeTypeDetector");
        }
        this.cache = cacheBuilder.build();
    }

    public void clearCache() {
        this.cache.clear();
    }

    public int getCacheHits() {
        return this.cache.getCacheHits();
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    public String getContentType(String fileName) {
        if (Utils.e(fileName)) {
            return this.defaultType;
        }
        String fileMimeType = this.fileMap.get(fileName);
        if (Utils.nn(fileMimeType)) {
            return fileMimeType;
        }
        return this.cache.get(fileName, () -> this.determineMimeType(fileName));
    }

    private String determineMimeType(String fileName) {
        String mimeType;
        String extension;
        if (this.nioContentBasedDetection) {
            try {
                String contentType;
                Path path = Paths.get(fileName, new String[0]);
                if (Files.exists(path, new LinkOption[0]) && Utils.ne(contentType = Files.probeContentType(path))) {
                    return contentType;
                }
            }
            catch (Exception path) {
                // empty catch block
            }
        }
        if (Utils.ne(extension = FileUtils.getFileExtension(fileName)) && Utils.nn(mimeType = this.extMap.get(extension.toLowerCase()))) {
            return mimeType;
        }
        return this.defaultType;
    }

    public static class Builder {
        private final Map<String, String> extMap = new ConcurrentHashMap<String, String>();
        private final Map<String, String> fileMap = new ConcurrentHashMap<String, String>();
        private boolean nioContentBasedDetection = true;
        private int cacheSize = 1000;
        private CacheMode cacheMode = CacheMode.FULL;
        private boolean cacheLogOnExit = false;
        private String defaultType = "application/octet-stream";

        public Builder addDefaultMappings() {
            return this.addTypes("application/epub+zip epub", "application/java-archive jar", "application/javascript js", "application/json json", "application/msword doc", "application/ogg ogx", "application/pdf pdf", "application/rtf rtf", "application/vnd.amazon.ebook azw", "application/vnd.apple.installer+xml mpkg", "application/vnd.mozilla.xul+xml xul", "application/vnd.ms-excel xls", "application/vnd.ms-powerpoint ppt", "application/vnd.oasis.opendocument.presentation odp", "application/vnd.oasis.opendocument.spreadsheet ods", "application/vnd.oasis.opendocument.text odt", "application/vnd.visio vsd", "application/x-7z-compressed 7z", "application/x-abiword abw", "application/x-bzip bz", "application/x-bzip2 bz2", "application/x-csh csh", "application/x-rar-compressed rar", "application/x-sh sh", "application/x-shockwave-flash swf", "application/x-tar tar", "application/xhtml+xml xhtml", "application/xml xml", "application/zip zip", "audio/aac aac", "audio/midi mid midi", "audio/ogg oga", "audio/webm weba", "audio/x-wav wav", "font/ttf ttf", "font/woff woff", "font/woff2 woff2", "image/gif gif", "image/jpeg jpeg jpg", "image/png png", "image/svg+xml svg", "image/tiff tif tiff", "image/webp webp", "image/x-icon ico", "text/calendar ics", "text/css css", "text/csv csv", "text/html htm html", "text/plain txt", "video/3gpp 3gp", "video/3gpp2 3g2", "video/mpeg mpeg", "video/ogg ogv", "video/webm webm", "video/x-msvideo avi");
        }

        public Builder addExtensionType(String ext, String type) {
            AssertionUtils.assertArgNotNullOrBlank("ext", ext);
            AssertionUtils.assertArgNotNullOrBlank("type", type);
            this.extMap.put(ext.toLowerCase(), type);
            return this;
        }

        public Builder addFileType(String name, String type) {
            AssertionUtils.assertArgNotNullOrBlank("name", name);
            AssertionUtils.assertArgNotNullOrBlank("type", type);
            this.fileMap.put(name, type);
            return this;
        }

        public Builder addNioContentBasedDetection(boolean value) {
            this.nioContentBasedDetection = value;
            return this;
        }

        public Builder addTypes(String ... mimeTypesLines) {
            for (String input : mimeTypesLines) {
                String[] lines;
                if (!Utils.ne(input)) continue;
                for (String line : lines = input.split("\\r?\\n")) {
                    String[] parts;
                    if (!Utils.ne(line) || line.trim().startsWith("#") || (parts = line.trim().split("\\s+")).length < 2) continue;
                    String mimeType = parts[0];
                    for (int i = 1; i < parts.length; ++i) {
                        this.addExtensionType(parts[i], mimeType);
                    }
                }
            }
            return this;
        }

        public MimeTypeDetector build() {
            return new MimeTypeDetector(this);
        }

        public Builder setCacheLogOnExit(boolean value) {
            this.cacheLogOnExit = value;
            return this;
        }

        public Builder setCacheMode(CacheMode value) {
            this.cacheMode = value;
            return this;
        }

        public Builder setCacheSize(int value) {
            this.cacheSize = value;
            return this;
        }

        public Builder setDefaultType(String value) {
            this.defaultType = value;
            return this;
        }
    }
}

