/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class FilteredMap<K, V>
extends AbstractMap<K, V> {
    private final BiPredicate<K, V> filter;
    private final Map<K, V> map;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Function<Object, K> keyFunction;
    private final Function<Object, V> valueFunction;

    public static <K, V> Builder<K, V> create(Class<K> keyType, Class<V> valueType) {
        AssertionUtils.assertArgNotNull("keyType", keyType);
        AssertionUtils.assertArgNotNull("valueType", valueType);
        Builder builder = new Builder();
        builder.keyType = keyType;
        builder.valueType = valueType;
        return builder;
    }

    public static <K, V> Builder<K, V> create() {
        Builder builder = new Builder();
        builder.keyType = Object.class;
        builder.valueType = Object.class;
        return builder;
    }

    protected FilteredMap(BiPredicate<K, V> filter, Map<K, V> map, Class<K> keyType, Class<V> valueType, Function<Object, K> keyFunction, Function<Object, V> valueFunction) {
        this.filter = AssertionUtils.assertArgNotNull("filter", filter);
        this.map = AssertionUtils.assertArgNotNull("map", map);
        this.keyType = AssertionUtils.assertArgNotNull("keyType", keyType);
        this.valueType = AssertionUtils.assertArgNotNull("valueType", valueType);
        this.keyFunction = keyFunction;
        this.valueFunction = valueFunction;
    }

    @Override
    public V put(K key, V value) {
        if (this.filter.test(key, value)) {
            return this.map.put(key, value);
        }
        return this.map.get(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            if (!this.filter.test(entry.getKey(), entry.getValue())) continue;
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean wouldAccept(K key, V value) {
        return this.filter.test(key, value);
    }

    public BiPredicate<K, V> getFilter() {
        return this.filter;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    public V add(Object key, Object value) {
        V convertedValue;
        K convertedKey = this.convertKey(key);
        if (this.filter.test(convertedKey, convertedValue = this.convertValue(value))) {
            return this.put(convertedKey, convertedValue);
        }
        return null;
    }

    public FilteredMap<K, V> addAll(Map<?, ?> source) {
        if (source != null) {
            for (Map.Entry<?, ?> entry : source.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public FilteredMap<K, V> addAny(Object ... values) {
        if (values != null) {
            for (Object o : values) {
                if (o == null || !(o instanceof Map)) continue;
                Map m = (Map)o;
                this.addAll(m);
            }
        }
        return this;
    }

    public FilteredMap<K, V> addPairs(Object ... pairs) {
        AssertionUtils.assertArgNotNull("pairs", pairs);
        if (pairs.length % 2 != 0) {
            throw ThrowableUtils.illegalArg("Odd number of parameters passed into addPairs()", new Object[0]);
        }
        for (int i = 0; i < pairs.length; i += 2) {
            this.add(pairs[i], pairs[i + 1]);
        }
        return this;
    }

    private K convertKey(Object key) {
        if (this.keyFunction != null) {
            key = this.keyFunction.apply(key);
        }
        if (key == null) {
            if (this.keyType.isPrimitive()) {
                throw ThrowableUtils.rex("Cannot set null key for primitive type {0}", this.keyType.getName());
            }
            return null;
        }
        if (this.keyType.isInstance(key)) {
            return this.keyType.cast(key);
        }
        throw ThrowableUtils.rex("Object of type {0} could not be converted to key type {1}", Utils.cn(key), Utils.cn(this.keyType));
    }

    private V convertValue(Object value) {
        if (this.valueFunction != null) {
            value = this.valueFunction.apply(value);
        }
        if (value == null) {
            if (this.valueType.isPrimitive()) {
                throw ThrowableUtils.rex("Cannot set null value for primitive type {0}", this.valueType.getName());
            }
            return null;
        }
        if (this.valueType.isInstance(value)) {
            return this.valueType.cast(value);
        }
        throw ThrowableUtils.rex("Object of type {0} could not be converted to value type {1}", Utils.cn(value), Utils.cn(this.valueType));
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public static class Builder<K, V> {
        private BiPredicate<K, V> filter = (k, v) -> true;
        private Map<K, V> inner;
        private Class<K> keyType;
        private Class<V> valueType;
        private Function<Object, K> keyFunction;
        private Function<Object, V> valueFunction;

        public Builder<K, V> filter(BiPredicate<K, V> value) {
            BiPredicate<K, V> newFilter = AssertionUtils.assertArgNotNull("value", value);
            this.filter = this.filter == null ? newFilter : this.filter.and(newFilter);
            return this;
        }

        public Builder<K, V> inner(Map<K, V> value) {
            this.inner = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        public Builder<K, V> keyFunction(Function<Object, K> value) {
            this.keyFunction = value;
            return this;
        }

        public Builder<K, V> valueFunction(Function<Object, V> value) {
            this.valueFunction = value;
            return this;
        }

        public Builder<K, V> functions(Function<Object, K> keyFunction, Function<Object, V> valueFunction) {
            this.keyFunction = keyFunction;
            this.valueFunction = valueFunction;
            return this;
        }

        public FilteredMap<K, V> build() {
            LinkedHashMap map = this.inner != null ? this.inner : new LinkedHashMap();
            return new FilteredMap<K, V>(this.filter, map, this.keyType, this.valueType, this.keyFunction, this.valueFunction);
        }
    }
}

