/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.beans;

import java.util.Collections;
import java.util.Map;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.beans.ResourceDescription;
import org.apache.juneau.rest.beans.ResourceDescriptions;

public class ChildResourceDescriptions
extends ResourceDescriptions {
    private static final long serialVersionUID = 1L;

    public static ChildResourceDescriptions of(RestRequest req) {
        return new ChildResourceDescriptions(req);
    }

    public ChildResourceDescriptions() {
    }

    public ChildResourceDescriptions(RestContext context, RestRequest req) {
        this(context, req, false);
    }

    public ChildResourceDescriptions(RestContext context, RestRequest req, boolean sort) {
        for (Map.Entry<String, RestContext> e : context.getRestChildren().asMap().entrySet()) {
            String title = null;
            try {
                title = e.getValue().getSwagger(req.getLocale()).map(x -> x == null ? null : x.getInfo()).map(x -> x == null ? null : x.getTitle()).orElse(null);
            }
            catch (Exception e1) {
                title = ThrowableUtils.lm(e1);
            }
            this.add(new ResourceDescription(e.getKey(), title));
        }
        if (sort) {
            Collections.sort(this);
        }
    }

    public ChildResourceDescriptions(RestRequest req) {
        this(req.getContext(), req, false);
    }

    @Override
    public ChildResourceDescriptions append(String name, String description) {
        super.append(name, description);
        return this;
    }

    @Override
    public ChildResourceDescriptions append(String name, String uri, String description) {
        super.append(name, uri, description);
        return this;
    }
}

