/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.EntityTag;

public class BasicEntityTagHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final EntityTag value;
    private final Supplier<EntityTag> supplier;

    public static BasicEntityTagHeader of(String name, EntityTag value) {
        return value == null ? null : new BasicEntityTagHeader(name, value);
    }

    public static BasicEntityTagHeader of(String name, String value) {
        return value == null ? null : new BasicEntityTagHeader(name, value);
    }

    public static BasicEntityTagHeader of(String name, Supplier<EntityTag> value) {
        return value == null ? null : new BasicEntityTagHeader(name, value);
    }

    public BasicEntityTagHeader(String name, EntityTag value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicEntityTagHeader(String name, String value) {
        super(name, value);
        this.value = EntityTag.of(value);
        this.supplier = null;
    }

    public BasicEntityTagHeader(String name, Supplier<EntityTag> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    public Optional<EntityTag> asEntityTag() {
        return Utils.opt((Object)this.value());
    }

    @Override
    public String getValue() {
        return Utils.s((Object)this.value());
    }

    public EntityTag orElse(EntityTag other) {
        EntityTag x = this.value();
        return Utils.nn((Object)x) ? x : other;
    }

    public EntityTag toEntityTag() {
        return this.value();
    }

    private EntityTag value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

