/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Set;
import org.apache.juneau.bean.swagger.SwaggerElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Xml
extends SwaggerElement {
    private String name;
    private String namespace;
    private String prefix;
    private Boolean attribute;
    private Boolean wrapped;

    public Xml() {
    }

    public Xml(Xml copyFrom) {
        super(copyFrom);
        this.attribute = copyFrom.attribute;
        this.name = copyFrom.name;
        this.namespace = copyFrom.namespace;
        this.prefix = copyFrom.prefix;
        this.wrapped = copyFrom.wrapped;
    }

    public Xml copy() {
        return new Xml(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "attribute" -> ConverterUtils.toType(this.getAttribute(), type);
            case "name" -> ConverterUtils.toType(this.getName(), type);
            case "namespace" -> ConverterUtils.toType(this.getNamespace(), type);
            case "prefix" -> ConverterUtils.toType(this.getPrefix(), type);
            case "wrapped" -> ConverterUtils.toType(this.getWrapped(), type);
            default -> super.get(property, type);
        };
    }

    public Boolean getAttribute() {
        return this.attribute;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Boolean getWrapped() {
        return this.wrapped;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.attribute), "attribute").addIf(Utils.nn(this.name), "name").addIf(Utils.nn(this.namespace), "namespace").addIf(Utils.nn(this.prefix), "prefix").addIf(Utils.nn(this.wrapped), "wrapped").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public Xml set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "attribute" -> this.setAttribute(ConverterUtils.toBoolean(value));
            case "name" -> this.setName(Utils.s(value));
            case "namespace" -> this.setNamespace(Utils.s(value));
            case "prefix" -> this.setPrefix(Utils.s(value));
            case "wrapped" -> this.setWrapped(ConverterUtils.toBoolean(value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Xml setAttribute(Boolean value) {
        this.attribute = value;
        return this;
    }

    public Xml setName(String value) {
        this.name = value;
        return this;
    }

    public Xml setNamespace(String value) {
        this.namespace = value;
        return this;
    }

    public Xml setPrefix(String value) {
        this.prefix = value;
        return this;
    }

    public Xml setWrapped(Boolean value) {
        this.wrapped = value;
        return this;
    }

    @Override
    public Xml strict() {
        super.strict();
        return this;
    }

    @Override
    public Xml strict(Object value) {
        super.strict(value);
        return this;
    }
}

