/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.entity.vo;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Set;
import org.apache.seata.server.console.entity.vo.BranchSessionVO;

public class GlobalSessionVO {
    private String xid;
    private String transactionId;
    private Integer status;
    private String applicationId;
    private String transactionServiceGroup;
    private String transactionName;
    private Long timeout;
    private Long beginTime;
    private String applicationData;
    private Long gmtCreate;
    private Long gmtModified;
    private Set<BranchSessionVO> branchSessionVOs;

    public GlobalSessionVO() {
    }

    public GlobalSessionVO(String xid, Long transactionId, Integer status, String applicationId, String transactionServiceGroup, String transactionName, Long timeout, Long beginTime, String applicationData, Set<BranchSessionVO> branchSessionVOs) {
        this.xid = xid;
        this.transactionId = String.valueOf(transactionId);
        this.status = status;
        this.applicationId = applicationId;
        this.transactionServiceGroup = transactionServiceGroup;
        this.transactionName = transactionName;
        this.timeout = timeout;
        this.beginTime = beginTime;
        this.applicationData = applicationData;
        this.branchSessionVOs = branchSessionVOs;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(Long transactionId) {
        this.transactionId = String.valueOf(transactionId);
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTransactionServiceGroup() {
        return this.transactionServiceGroup;
    }

    public void setTransactionServiceGroup(String transactionServiceGroup) {
        this.transactionServiceGroup = transactionServiceGroup;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public Long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Long beginTime) {
        this.beginTime = beginTime;
    }

    public String getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(String applicationData) {
        this.applicationData = applicationData;
    }

    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Long getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Set<BranchSessionVO> getBranchSessionVOs() {
        return this.branchSessionVOs;
    }

    public void setBranchSessionVOs(Set<BranchSessionVO> branchSessionVOs) {
        this.branchSessionVOs = branchSessionVOs;
    }

    public static GlobalSessionVO convert(ResultSet rs) throws SQLException {
        Timestamp gmtModifiedTimestamp;
        GlobalSessionVO globalSessionVO = new GlobalSessionVO();
        globalSessionVO.setXid(rs.getString("xid"));
        globalSessionVO.setTransactionId(rs.getLong("transaction_id"));
        globalSessionVO.setStatus(rs.getInt("status"));
        globalSessionVO.setApplicationId(rs.getString("application_id"));
        globalSessionVO.setTransactionServiceGroup(rs.getString("transaction_service_group"));
        globalSessionVO.setTransactionName(rs.getString("transaction_name"));
        globalSessionVO.setTimeout(rs.getLong("timeout"));
        globalSessionVO.setBeginTime(rs.getLong("begin_time"));
        globalSessionVO.setApplicationData(rs.getString("application_data"));
        Timestamp gmtCreateTimestamp = rs.getTimestamp("gmt_create");
        if (gmtCreateTimestamp != null) {
            globalSessionVO.setGmtCreate(gmtCreateTimestamp.getTime());
        }
        if ((gmtModifiedTimestamp = rs.getTimestamp("gmt_modified")) != null) {
            globalSessionVO.setGmtModified(gmtModifiedTimestamp.getTime());
        }
        return globalSessionVO;
    }

    public String toString() {
        return "GlobalSessionVO{xid='" + this.xid + '\'' + ", transactionId=" + this.transactionId + ", status=" + this.status + ", applicationId='" + this.applicationId + '\'' + ", transactionServiceGroup='" + this.transactionServiceGroup + '\'' + ", transactionName='" + this.transactionName + '\'' + ", timeout=" + this.timeout + ", beginTime=" + this.beginTime + ", applicationData='" + this.applicationData + '\'' + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", branchSessionVOs=" + this.branchSessionVOs + '}';
    }
}

