/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.changed.tool;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Consumer;
import org.springaicommunity.mcp.method.changed.tool.AbstractMcpToolListChangedMethodCallback;

public final class SyncMcpToolListChangedMethodCallback
extends AbstractMcpToolListChangedMethodCallback
implements Consumer<List<McpSchema.Tool>> {
    private SyncMcpToolListChangedMethodCallback(Builder builder) {
        super(builder.method, builder.bean);
    }

    @Override
    public void accept(List<McpSchema.Tool> updatedTools) {
        if (updatedTools == null) {
            throw new IllegalArgumentException("Updated tools list must not be null");
        }
        try {
            Object[] args = this.buildArgs(this.method, null, updatedTools);
            this.method.setAccessible(true);
            this.method.invoke(this.bean, args);
        }
        catch (Exception e) {
            throw new AbstractMcpToolListChangedMethodCallback.McpToolListChangedConsumerMethodException("Error invoking tool list changed consumer method: " + this.method.getName(), e);
        }
    }

    @Override
    protected void validateReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE) {
            throw new IllegalArgumentException("Method must have void return type: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpToolListChangedMethodCallback.AbstractBuilder<Builder, SyncMcpToolListChangedMethodCallback> {
        @Override
        public SyncMcpToolListChangedMethodCallback build() {
            this.validate();
            return new SyncMcpToolListChangedMethodCallback(this);
        }
    }
}

