/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.tls;

import com.alibaba.nacos.common.utils.IoUtils;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelfTrustManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfTrustManager.class);
    static TrustManager[] trustAll = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};

    public static TrustManager[] trustManager(boolean needAuth, String trustCertPath) {
        if (needAuth) {
            try {
                return trustCertPath == null ? null : SelfTrustManager.buildSecureTrustManager(trustCertPath);
            }
            catch (SSLException e) {
                LOGGER.warn("degrade trust manager as build failed, will trust all certs.");
                return trustAll;
            }
        }
        return trustAll;
    }

    private static TrustManager[] buildSecureTrustManager(String trustCertPath) throws SSLException {
        TrustManager[] trustManagerArray;
        FileInputStream in = null;
        try {
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory selfTmf = TrustManagerFactory.getInstance(algorithm);
            KeyStore trustKeyStore = KeyStore.getInstance("JKS");
            trustKeyStore.load(null, null);
            in = new FileInputStream(trustCertPath);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = cf.generateCertificates(in);
            int count = 0;
            for (Certificate certificate : certs) {
                trustKeyStore.setCertificateEntry("cert-" + count++, certificate);
            }
            selfTmf.init(trustKeyStore);
            trustManagerArray = selfTmf.getTrustManagers();
        }
        catch (Exception e) {
            try {
                LOGGER.error("build client trustManagerFactory failed", (Throwable)e);
                throw new SSLException(e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
        return trustManagerArray;
    }
}

