/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandError;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.UnsupportedTypeException;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UnsupportedTypeError
implements CommandError,
ComparableByContent<UnsupportedTypeError> {
    private final int typeId;
    public static SerializationHandle<UnsupportedTypeError> SERIALIZATION_HANDLE = new SerializationHandle<UnsupportedTypeError>(){

        @Override
        public <S> UnsupportedTypeError deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int typeId = adapter.readInt(input);
            return new UnsupportedTypeError(typeId);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, UnsupportedTypeError error, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeInt(output, error.typeId);
        }

        @Override
        public int getTypeId() {
            return 16;
        }

        @Override
        public Class<UnsupportedTypeError> getSerializedType() {
            return UnsupportedTypeError.class;
        }

        @Override
        public UnsupportedTypeError fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int typeId = this.readIntValue(snapshot, "typeId");
            return new UnsupportedTypeError(typeId);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(UnsupportedTypeError error, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("typeId", error.typeId);
            return result;
        }

        @Override
        public String getTypeName() {
            return "UnsupportedTypeError";
        }
    };

    public UnsupportedTypeError(int typeId) {
        this.typeId = typeId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    @Override
    public RuntimeException asException() {
        return new UnsupportedTypeException(this.typeId);
    }

    @Override
    public boolean equalsByContent(UnsupportedTypeError other) {
        return other.typeId == this.typeId;
    }
}

