/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.provider;

import com.alipay.sofa.registry.client.api.Register;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.registration.BaseRegistration;
import com.alipay.sofa.registry.client.auth.AuthManager;
import com.alipay.sofa.registry.client.util.StringUtils;
import com.alipay.sofa.registry.core.model.BaseRegister;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractInternalRegister
implements Register {
    private final AtomicLong initialVersion = new AtomicLong(0L);
    private AuthManager authManager;
    private volatile boolean registered = false;
    private volatile boolean enabled = true;
    private volatile boolean refused = false;
    private AtomicLong pubVersion = new AtomicLong(0L);
    private AtomicLong ackVersion = new AtomicLong(0L);
    private volatile long timestamp = System.currentTimeMillis();
    private volatile int registerCount = 0;
    private volatile String requestId = UUID.randomUUID().toString();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    protected Lock readLock = this.lock.readLock();
    protected Lock writeLock = this.lock.writeLock();

    public abstract Object assembly();

    @Override
    public boolean isRegistered() {
        this.readLock.lock();
        try {
            boolean bl = this.registered;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void waitToSync() {
        this.writeLock.lock();
        try {
            this.registered = false;
            this.requestId = UUID.randomUUID().toString();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncOK(String requestId, long version, boolean refused) {
        this.writeLock.lock();
        try {
            if (this.requestId.equals(requestId)) {
                this.registered = true;
                this.refused = refused;
                this.setAckVersion(version);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean isEnabled() {
        this.readLock.lock();
        try {
            boolean bl = this.enabled;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void refused(String requestId) {
        this.writeLock.lock();
        try {
            if (this.requestId.equals(requestId)) {
                this.enabled = false;
                this.refused = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isDone() {
        this.readLock.lock();
        try {
            boolean bl = this.isRegistered() && this.pubVersion.get() == this.ackVersion.get() || this.isRefused();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public SyncTask assemblySyncTask() {
        this.readLock.lock();
        try {
            SyncTask syncTask = new SyncTask();
            syncTask.setRequestId(this.requestId);
            syncTask.setRequest(this.assembly());
            syncTask.setDone(this.isDone());
            SyncTask syncTask2 = syncTask;
            return syncTask2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public AtomicLong getPubVersion() {
        return this.pubVersion;
    }

    public void setAckVersion(Long version) {
        if (null == version) {
            return;
        }
        long current = this.ackVersion.get();
        if (version <= current) {
            return;
        }
        boolean result = this.ackVersion.compareAndSet(current, version);
        if (result) {
            return;
        }
        this.setAckVersion(version);
    }

    @Override
    public void reset() {
        this.writeLock.lock();
        try {
            this.registered = false;
            this.registerCount = 0;
            this.timestamp = System.currentTimeMillis();
            this.ackVersion = new AtomicLong(this.initialVersion.longValue());
            this.requestId = UUID.randomUUID().toString();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void unregister() {
        this.writeLock.lock();
        try {
            this.enabled = false;
            this.pubVersion.incrementAndGet();
            this.requestId = UUID.randomUUID().toString();
            this.registerCount = 0;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    boolean isRefused() {
        this.readLock.lock();
        try {
            boolean bl = this.refused;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getTimestamp() {
        this.readLock.lock();
        try {
            long l = this.timestamp;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void setTimestamp(long timestamp) {
        this.writeLock.lock();
        try {
            this.timestamp = timestamp;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void setAuthSignature(BaseRegister register) {
        if (null != this.authManager) {
            Map<String, String> authAttributes = this.authManager.getAuthContent(register);
            Map<String, String> registerAttributes = register.getAttributes();
            if (null == registerAttributes) {
                registerAttributes = new HashMap<String, String>();
            }
            registerAttributes.putAll(authAttributes);
            register.setAttributes(registerAttributes);
        }
    }

    public void setAuthManager(AuthManager authManager) {
        this.authManager = authManager;
    }

    protected void setAttributes(BaseRegister to, BaseRegistration from, RegistryClientConfig config) {
        if (StringUtils.isNotEmpty(from.getInstanceId())) {
            to.setInstanceId(from.getInstanceId());
        } else {
            to.setInstanceId(config.getInstanceId());
        }
        if (StringUtils.isNotEmpty(config.getZone())) {
            to.setZone(config.getZone());
        } else {
            to.setZone("DEFAULT_ZONE");
        }
        if (StringUtils.isNotEmpty(from.getAppName())) {
            to.setAppName(from.getAppName());
        } else {
            to.setAppName(config.getAppName());
        }
        if (StringUtils.isNotEmpty(from.getIp())) {
            to.setIp(from.getIp());
        } else {
            to.setIp(config.getIp());
        }
        to.setDataId(from.getDataId());
        to.setGroup(from.getGroup());
        to.setVersion(this.getPubVersion().get());
        to.setTimestamp(this.getTimestamp());
    }

    public String toString() {
        return "AbstractInternalRegister{initialVersion=" + this.initialVersion + ", registered=" + this.registered + ", enabled=" + this.enabled + ", refused=" + this.refused + ", pubVersion=" + this.pubVersion + ", ackVersion=" + this.ackVersion + ", timestamp=" + this.timestamp + ", registerCount=" + this.registerCount + ", requestId='" + this.requestId + '}';
    }

    public static class SyncTask {
        private String requestId;
        private Object request;
        private boolean done;

        public String getRequestId() {
            return this.requestId;
        }

        void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public Object getRequest() {
            return this.request;
        }

        void setRequest(Object request) {
            this.request = request;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }
    }
}

