/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.config.ApplyFaultToleranceConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class ApplyFaultToleranceConfigImpl
implements ApplyFaultToleranceConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final boolean onMethod;
    private final String description;
    private final String configKey;
    private final ApplyFaultTolerance instance;
    private String _value;

    private ApplyFaultToleranceConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(ApplyFaultTolerance.class);
        this.description = method.method.toString();
        this.configKey = this.onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.applyFaultTolerance;
    }

    public static ApplyFaultToleranceConfigImpl create(FaultToleranceMethod method) {
        if (method.applyFaultTolerance == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled((String)"apply-fault-tolerance.enabled", (String)"ApplyFaultTolerance/enabled", (MethodDescriptor)method.method)) {
            return null;
        }
        return new ApplyFaultToleranceConfigImpl(method);
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return ApplyFaultTolerance.class;
    }

    public String value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            Object key = this.configKey + "/ApplyFaultTolerance/value";
            this._value = config.getOptionalValue((String)key, String.class).orElse(null);
            if (this._value == null) {
                key = "ApplyFaultTolerance/value";
                this._value = config.getOptionalValue((String)key, String.class).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public void materialize() {
        this.value();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @ApplyFaultTolerance on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @ApplyFaultTolerance." + member + " on " + this.description + ": " + reason);
    }
}

