/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.config;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.polaris.service.config.FeaturesConfiguration;
import org.apache.polaris.service.config.RawFeaturesConfiguration;
import org.apache.polaris.service.config.RealmOverridable;

@ApplicationScoped
@Alternative
@Priority(value=1)
public class ResolvedFeaturesConfiguration
implements FeaturesConfiguration {
    private Map<String, String> cleanedDefaults;
    private Map<String, RealmOverridable.RealmOverrides> realmOverrides;

    public ResolvedFeaturesConfiguration(RawFeaturesConfiguration raw) {
        this.realmOverrides = raw.realmOverrides();
        this.cleanedDefaults = raw.defaults().entrySet().stream().filter(e -> ((String)e.getKey()).split("\\.").length == 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, String> defaults() {
        return this.cleanedDefaults;
    }

    public Map<String, RealmOverridable.RealmOverrides> realmOverrides() {
        return this.realmOverrides;
    }

    public ResolvedFeaturesConfiguration() {
    }
}

