/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLogEventsRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, GetLogEventsRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(GetLogEventsRequest.getter(GetLogEventsRequest::logGroupName)).setter(GetLogEventsRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupIdentifier").getter(GetLogEventsRequest.getter(GetLogEventsRequest::logGroupIdentifier)).setter(GetLogEventsRequest.setter(Builder::logGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build()}).build();
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStreamName").getter(GetLogEventsRequest.getter(GetLogEventsRequest::logStreamName)).setter(GetLogEventsRequest.setter(Builder::logStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()}).build();
    private static final SdkField<Long> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startTime").getter(GetLogEventsRequest.getter(GetLogEventsRequest::startTime)).setter(GetLogEventsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Long> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("endTime").getter(GetLogEventsRequest.getter(GetLogEventsRequest::endTime)).setter(GetLogEventsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetLogEventsRequest.getter(GetLogEventsRequest::nextToken)).setter(GetLogEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(GetLogEventsRequest.getter(GetLogEventsRequest::limit)).setter(GetLogEventsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final SdkField<Boolean> START_FROM_HEAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("startFromHead").getter(GetLogEventsRequest.getter(GetLogEventsRequest::startFromHead)).setter(GetLogEventsRequest.setter(Builder::startFromHead)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startFromHead").build()}).build();
    private static final SdkField<Boolean> UNMASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("unmask").getter(GetLogEventsRequest.getter(GetLogEventsRequest::unmask)).setter(GetLogEventsRequest.setter(Builder::unmask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmask").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, LOG_GROUP_IDENTIFIER_FIELD, LOG_STREAM_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD, START_FROM_HEAD_FIELD, UNMASK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLogEventsRequest.memberNameToFieldInitializer();
    private final String logGroupName;
    private final String logGroupIdentifier;
    private final String logStreamName;
    private final Long startTime;
    private final Long endTime;
    private final String nextToken;
    private final Integer limit;
    private final Boolean startFromHead;
    private final Boolean unmask;

    private GetLogEventsRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.logStreamName = builder.logStreamName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.startFromHead = builder.startFromHead;
        this.unmask = builder.unmask;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final String logGroupIdentifier() {
        return this.logGroupIdentifier;
    }

    public final String logStreamName() {
        return this.logStreamName;
    }

    public final Long startTime() {
        return this.startTime;
    }

    public final Long endTime() {
        return this.endTime;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final Boolean startFromHead() {
        return this.startFromHead;
    }

    public final Boolean unmask() {
        return this.unmask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.startFromHead());
        hashCode = 31 * hashCode + Objects.hashCode(this.unmask());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogEventsRequest)) {
            return false;
        }
        GetLogEventsRequest other = (GetLogEventsRequest)((Object)obj);
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.logGroupIdentifier(), other.logGroupIdentifier()) && Objects.equals(this.logStreamName(), other.logStreamName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.startFromHead(), other.startFromHead()) && Objects.equals(this.unmask(), other.unmask());
    }

    public final String toString() {
        return ToString.builder((String)"GetLogEventsRequest").add("LogGroupName", (Object)this.logGroupName()).add("LogGroupIdentifier", (Object)this.logGroupIdentifier()).add("LogStreamName", (Object)this.logStreamName()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).add("StartFromHead", (Object)this.startFromHead()).add("Unmask", (Object)this.unmask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "logGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifier()));
            }
            case "logStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "startFromHead": {
                return Optional.ofNullable(clazz.cast(this.startFromHead()));
            }
            case "unmask": {
                return Optional.ofNullable(clazz.cast(this.unmask()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
        map.put("logStreamName", LOG_STREAM_NAME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("startFromHead", START_FROM_HEAD_FIELD);
        map.put("unmask", UNMASK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLogEventsRequest, T> g) {
        return obj -> g.apply((GetLogEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupName;
        private String logGroupIdentifier;
        private String logStreamName;
        private Long startTime;
        private Long endTime;
        private String nextToken;
        private Integer limit;
        private Boolean startFromHead;
        private Boolean unmask;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogEventsRequest model) {
            super(model);
            this.logGroupName(model.logGroupName);
            this.logGroupIdentifier(model.logGroupIdentifier);
            this.logStreamName(model.logStreamName);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
            this.startFromHead(model.startFromHead);
            this.unmask(model.unmask);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getLogGroupIdentifier() {
            return this.logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final Long getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Boolean getStartFromHead() {
            return this.startFromHead;
        }

        public final void setStartFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
        }

        @Override
        public final Builder startFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
            return this;
        }

        public final Boolean getUnmask() {
            return this.unmask;
        }

        public final void setUnmask(Boolean unmask) {
            this.unmask = unmask;
        }

        @Override
        public final Builder unmask(Boolean unmask) {
            this.unmask = unmask;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLogEventsRequest build() {
            return new GetLogEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLogEventsRequest> {
        public Builder logGroupName(String var1);

        public Builder logGroupIdentifier(String var1);

        public Builder logStreamName(String var1);

        public Builder startTime(Long var1);

        public Builder endTime(Long var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder startFromHead(Boolean var1);

        public Builder unmask(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

