/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.identity.credential;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.polaris.core.admin.model.AwsIamServiceIdentityInfo;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;
import org.apache.polaris.core.identity.ServiceIdentityType;
import org.apache.polaris.core.identity.credential.ServiceIdentityCredential;
import org.apache.polaris.core.identity.dpo.AwsIamServiceIdentityInfoDpo;
import org.apache.polaris.core.identity.dpo.ServiceIdentityInfoDpo;
import org.apache.polaris.core.secrets.SecretReference;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

public class AwsIamServiceIdentityCredential
extends ServiceIdentityCredential {
    private final String iamArn;
    private final AwsCredentialsProvider awsCredentialsProvider;

    public AwsIamServiceIdentityCredential(@Nullable String iamArn) {
        this(null, iamArn, (AwsCredentialsProvider)DefaultCredentialsProvider.builder().build());
    }

    public AwsIamServiceIdentityCredential(@Nullable String iamArn, @Nonnull AwsCredentialsProvider awsCredentialsProvider) {
        this(null, iamArn, awsCredentialsProvider);
    }

    public AwsIamServiceIdentityCredential(@Nullable SecretReference secretReference, @Nullable String iamArn, @Nonnull AwsCredentialsProvider awsCredentialsProvider) {
        super(ServiceIdentityType.AWS_IAM, secretReference);
        this.iamArn = iamArn;
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    @Nullable
    public String getIamArn() {
        return this.iamArn;
    }

    @Nonnull
    public AwsCredentialsProvider getAwsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }

    @Override
    @Nonnull
    public ServiceIdentityInfoDpo asServiceIdentityInfoDpo() {
        return new AwsIamServiceIdentityInfoDpo(this.getIdentityInfoReference());
    }

    @Override
    @Nonnull
    public ServiceIdentityInfo asServiceIdentityInfoModel() {
        return AwsIamServiceIdentityInfo.builder().setIdentityType(ServiceIdentityInfo.IdentityTypeEnum.AWS_IAM).setIamArn(this.getIamArn()).build();
    }
}

