/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BufferHandlePool;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.MetadataField;
import com.google.cloud.storage.ParallelCompositeUploadWritableByteChannel;
import com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.storage.StorageInternal;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.WritableByteChannelSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Clock;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.NonNull;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
@Immutable
public final class ParallelCompositeUploadBlobWriteSessionConfig
extends BlobWriteSessionConfig
implements BlobWriteSessionConfig.HttpCompatible,
BlobWriteSessionConfig.GrpcCompatible {
    private static final int MAX_PARTS_PER_COMPOSE = 32;
    private final int maxPartsPerCompose;
    private final ExecutorSupplier executorSupplier;
    private final BufferAllocationStrategy bufferAllocationStrategy;
    private final PartNamingStrategy partNamingStrategy;
    private final PartCleanupStrategy partCleanupStrategy;
    private final PartMetadataFieldDecorator partMetadataFieldDecorator;

    private ParallelCompositeUploadBlobWriteSessionConfig(int maxPartsPerCompose, ExecutorSupplier executorSupplier, BufferAllocationStrategy bufferAllocationStrategy, PartNamingStrategy partNamingStrategy, PartCleanupStrategy partCleanupStrategy, PartMetadataFieldDecorator partMetadataFieldDecorator) {
        this.maxPartsPerCompose = maxPartsPerCompose;
        this.executorSupplier = executorSupplier;
        this.bufferAllocationStrategy = bufferAllocationStrategy;
        this.partNamingStrategy = partNamingStrategy;
        this.partCleanupStrategy = partCleanupStrategy;
        this.partMetadataFieldDecorator = partMetadataFieldDecorator;
    }

    @InternalApi
    ParallelCompositeUploadBlobWriteSessionConfig withMaxPartsPerCompose(int maxPartsPerCompose) {
        Preconditions.checkArgument((2 <= maxPartsPerCompose && maxPartsPerCompose <= 32 ? 1 : 0) != 0, (String)"2 <= maxPartsPerCompose <= 32 (2 <= %s <= 32)", (int)maxPartsPerCompose);
        return new ParallelCompositeUploadBlobWriteSessionConfig(maxPartsPerCompose, this.executorSupplier, this.bufferAllocationStrategy, this.partNamingStrategy, this.partCleanupStrategy, this.partMetadataFieldDecorator);
    }

    @BetaApi
    public ParallelCompositeUploadBlobWriteSessionConfig withExecutorSupplier(ExecutorSupplier executorSupplier) {
        Preconditions.checkNotNull((Object)executorSupplier, (Object)"executorSupplier must be non null");
        return new ParallelCompositeUploadBlobWriteSessionConfig(this.maxPartsPerCompose, executorSupplier, this.bufferAllocationStrategy, this.partNamingStrategy, this.partCleanupStrategy, this.partMetadataFieldDecorator);
    }

    @BetaApi
    public ParallelCompositeUploadBlobWriteSessionConfig withBufferAllocationStrategy(BufferAllocationStrategy bufferAllocationStrategy) {
        Preconditions.checkNotNull((Object)bufferAllocationStrategy, (Object)"bufferAllocationStrategy must be non null");
        return new ParallelCompositeUploadBlobWriteSessionConfig(this.maxPartsPerCompose, this.executorSupplier, bufferAllocationStrategy, this.partNamingStrategy, this.partCleanupStrategy, this.partMetadataFieldDecorator);
    }

    @BetaApi
    public ParallelCompositeUploadBlobWriteSessionConfig withPartNamingStrategy(PartNamingStrategy partNamingStrategy) {
        Preconditions.checkNotNull((Object)partNamingStrategy, (Object)"partNamingStrategy must be non null");
        return new ParallelCompositeUploadBlobWriteSessionConfig(this.maxPartsPerCompose, this.executorSupplier, this.bufferAllocationStrategy, partNamingStrategy, this.partCleanupStrategy, this.partMetadataFieldDecorator);
    }

    @BetaApi
    public ParallelCompositeUploadBlobWriteSessionConfig withPartCleanupStrategy(PartCleanupStrategy partCleanupStrategy) {
        Preconditions.checkNotNull((Object)partCleanupStrategy, (Object)"partCleanupStrategy must be non null");
        return new ParallelCompositeUploadBlobWriteSessionConfig(this.maxPartsPerCompose, this.executorSupplier, this.bufferAllocationStrategy, this.partNamingStrategy, partCleanupStrategy, this.partMetadataFieldDecorator);
    }

    @BetaApi
    public ParallelCompositeUploadBlobWriteSessionConfig withPartMetadataFieldDecorator(PartMetadataFieldDecorator partMetadataFieldDecorator) {
        Preconditions.checkNotNull((Object)partMetadataFieldDecorator, (Object)"partMetadataFieldDecorator must be non null");
        return new ParallelCompositeUploadBlobWriteSessionConfig(this.maxPartsPerCompose, this.executorSupplier, this.bufferAllocationStrategy, this.partNamingStrategy, this.partCleanupStrategy, partMetadataFieldDecorator);
    }

    @BetaApi
    static ParallelCompositeUploadBlobWriteSessionConfig withDefaults() {
        return new ParallelCompositeUploadBlobWriteSessionConfig(32, ExecutorSupplier.cachedPool(), BufferAllocationStrategy.simple(0x1000000), PartNamingStrategy.noPrefix(), PartCleanupStrategy.always(), PartMetadataFieldDecorator.noOp());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParallelCompositeUploadBlobWriteSessionConfig)) {
            return false;
        }
        ParallelCompositeUploadBlobWriteSessionConfig that = (ParallelCompositeUploadBlobWriteSessionConfig)o;
        return this.maxPartsPerCompose == that.maxPartsPerCompose && Objects.equals(this.executorSupplier, that.executorSupplier) && Objects.equals(this.bufferAllocationStrategy, that.bufferAllocationStrategy) && Objects.equals(this.partNamingStrategy, that.partNamingStrategy) && Objects.equals(this.partCleanupStrategy, that.partCleanupStrategy) && Objects.equals(this.partMetadataFieldDecorator, that.partMetadataFieldDecorator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.maxPartsPerCompose, this.executorSupplier, this.bufferAllocationStrategy, this.partNamingStrategy, this.partCleanupStrategy, this.partMetadataFieldDecorator);
    }

    @Override
    @InternalApi
    BlobWriteSessionConfig.WriterFactory createFactory(Clock clock) throws IOException {
        Executor executor = (Executor)this.executorSupplier.get();
        BufferHandlePool bufferHandlePool = (BufferHandlePool)this.bufferAllocationStrategy.get();
        PartMetadataFieldDecoratorInstance partMetadataFieldDecoratorInstance = this.partMetadataFieldDecorator.newInstance(clock);
        return new ParallelCompositeUploadWriterFactory(clock, executor, bufferHandlePool, partMetadataFieldDecoratorInstance);
    }

    @BetaApi
    @Immutable
    public static class PartCleanupStrategy
    implements Serializable {
        private static final long serialVersionUID = -1434253614347199051L;
        private final boolean deletePartsOnSuccess;
        private final boolean deleteAllOnError;

        private PartCleanupStrategy(boolean deletePartsOnSuccess, boolean deleteAllOnError) {
            this.deletePartsOnSuccess = deletePartsOnSuccess;
            this.deleteAllOnError = deleteAllOnError;
        }

        boolean isDeletePartsOnSuccess() {
            return this.deletePartsOnSuccess;
        }

        boolean isDeleteAllOnError() {
            return this.deleteAllOnError;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PartCleanupStrategy)) {
                return false;
            }
            PartCleanupStrategy that = (PartCleanupStrategy)o;
            return this.deletePartsOnSuccess == that.deletePartsOnSuccess && this.deleteAllOnError == that.deleteAllOnError;
        }

        public int hashCode() {
            return Objects.hash(this.deletePartsOnSuccess, this.deleteAllOnError);
        }

        @BetaApi
        PartCleanupStrategy withDeleteAllOnError(boolean deleteAllOnError) {
            return new PartCleanupStrategy(this.deletePartsOnSuccess, deleteAllOnError);
        }

        @BetaApi
        public static PartCleanupStrategy always() {
            return new PartCleanupStrategy(true, true);
        }

        @BetaApi
        public static PartCleanupStrategy onlyOnSuccess() {
            return new PartCleanupStrategy(true, false);
        }

        @BetaApi
        public static PartCleanupStrategy never() {
            return new PartCleanupStrategy(false, false);
        }
    }

    @BetaApi
    @Immutable
    public static abstract class PartNamingStrategy
    implements Serializable {
        private static final long serialVersionUID = 8343436026774231869L;
        private static final String FIELD_SEPARATOR = ";";
        private static final Base64.Encoder B64 = Base64.getUrlEncoder().withoutPadding();
        private static final HashFunction OBJECT_NAME_HASH_FUNCTION = Hashing.goodFastHash((int)128);
        private final SecureRandom rand;

        @InternalApi
        @VisibleForTesting
        PartNamingStrategy(SecureRandom rand) {
            this.rand = rand;
        }

        String fmtName(String ultimateObjectName, MetadataField.PartRange partRange) {
            byte[] bytes = new byte[16];
            this.rand.nextBytes(bytes);
            String randomKey = B64.encodeToString(bytes);
            return this.fmtFields(randomKey, ultimateObjectName, partRange.encode());
        }

        abstract String fmtFields(String var1, String var2, String var3);

        @BetaApi
        public static PartNamingStrategy noPrefix() {
            SecureRandom rand = new SecureRandom();
            return new NoPrefix(rand);
        }

        @BetaApi
        public static PartNamingStrategy prefix(String prefixPattern) {
            Preconditions.checkNotNull((Object)prefixPattern, (Object)"prefixPattern must be non null");
            SecureRandom rand = new SecureRandom();
            return new WithPrefix(rand, prefixPattern);
        }

        @BetaApi
        public static PartNamingStrategy useObjectNameAsPrefix() {
            return PartNamingStrategy.useObjectNameAsPrefix("");
        }

        private static PartNamingStrategy useObjectNameAsPrefix(String prefixPattern) {
            Preconditions.checkNotNull((Object)prefixPattern, (Object)"prefixPattern must be non null");
            SecureRandom rand = new SecureRandom();
            return new WithObjectLevelPrefix(rand, prefixPattern);
        }

        static final class NoPrefix
        extends PartNamingStrategy {
            private static final long serialVersionUID = 5202415556658566017L;

            public NoPrefix(SecureRandom rand) {
                super(rand);
            }

            @Override
            protected String fmtFields(String randomKey, String ultimateObjectName, String partRange) {
                HashCode hashCode = OBJECT_NAME_HASH_FUNCTION.hashString((CharSequence)ultimateObjectName, StandardCharsets.UTF_8);
                String nameDigest = B64.encodeToString(hashCode.asBytes());
                return randomKey + PartNamingStrategy.FIELD_SEPARATOR + nameDigest + PartNamingStrategy.FIELD_SEPARATOR + partRange + ".part";
            }
        }

        static final class WithPrefix
        extends PartNamingStrategy {
            private static final long serialVersionUID = 5709330763161570411L;
            private final String prefix;

            private WithPrefix(SecureRandom rand, String prefix) {
                super(rand);
                this.prefix = prefix;
            }

            @Override
            protected String fmtFields(String randomKey, String ultimateObjectName, String partRange) {
                HashCode hashCode = OBJECT_NAME_HASH_FUNCTION.hashString((CharSequence)ultimateObjectName, StandardCharsets.UTF_8);
                String nameDigest = B64.encodeToString(hashCode.asBytes());
                return this.prefix + "/" + randomKey + PartNamingStrategy.FIELD_SEPARATOR + nameDigest + PartNamingStrategy.FIELD_SEPARATOR + partRange + ".part";
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof WithPrefix)) {
                    return false;
                }
                WithPrefix that = (WithPrefix)o;
                return Objects.equals(this.prefix, that.prefix);
            }

            public int hashCode() {
                return Objects.hashCode(this.prefix);
            }
        }

        static final class WithObjectLevelPrefix
        extends PartNamingStrategy {
            private static final long serialVersionUID = 5157942020618764450L;
            private final String prefix;

            private WithObjectLevelPrefix(SecureRandom rand, String prefix) {
                super(rand);
                this.prefix = prefix.isEmpty() ? prefix : prefix + "/";
            }

            @Override
            protected String fmtFields(String randomKey, String ultimateObjectName, String partRange) {
                HashCode hashCode = OBJECT_NAME_HASH_FUNCTION.hashString((CharSequence)ultimateObjectName, StandardCharsets.UTF_8);
                String nameDigest = B64.encodeToString(hashCode.asBytes());
                return this.prefix + ultimateObjectName + "-" + randomKey + PartNamingStrategy.FIELD_SEPARATOR + nameDigest + PartNamingStrategy.FIELD_SEPARATOR + partRange + ".part";
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof WithObjectLevelPrefix)) {
                    return false;
                }
                WithObjectLevelPrefix that = (WithObjectLevelPrefix)o;
                return Objects.equals(this.prefix, that.prefix);
            }

            public int hashCode() {
                return Objects.hashCode(this.prefix);
            }
        }
    }

    @BetaApi
    @Immutable
    public static abstract class ExecutorSupplier
    extends Factory<Executor>
    implements Serializable {
        private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(1);

        private ExecutorSupplier() {
        }

        @BetaApi
        public static ExecutorSupplier cachedPool() {
            return CachedSupplier.INSTANCE;
        }

        @BetaApi
        public static ExecutorSupplier fixedPool(int poolSize) {
            Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)"poolSize must be > 0");
            return new FixedSupplier(poolSize);
        }

        @BetaApi
        public static ExecutorSupplier useExecutor(Executor executor) {
            Objects.requireNonNull(executor, "executor must be non null");
            return new SuppliedExecutorSupplier(executor);
        }

        private static @NonNull ThreadFactory newThreadFactory() {
            return new ThreadFactoryBuilder().setDaemon(true).setNameFormat("c.g.c:g-c-s:pcu-" + INSTANCE_COUNTER.getAndIncrement() + "-%d").build();
        }

        private static class CachedSupplier
        extends ExecutorSupplier
        implements Serializable {
            private static final long serialVersionUID = 7768210719775319260L;
            private static final CachedSupplier INSTANCE = new CachedSupplier();

            private CachedSupplier() {
            }

            @Override
            Executor get() {
                ThreadFactory threadFactory = ExecutorSupplier.newThreadFactory();
                return Executors.newCachedThreadPool(threadFactory);
            }

            private Object readResolve() {
                return INSTANCE;
            }
        }

        private static class FixedSupplier
        extends ExecutorSupplier
        implements Serializable {
            private static final long serialVersionUID = 7771825977551614347L;
            private final int poolSize;

            public FixedSupplier(int poolSize) {
                this.poolSize = poolSize;
            }

            @Override
            Executor get() {
                ThreadFactory threadFactory = ExecutorSupplier.newThreadFactory();
                return Executors.newFixedThreadPool(this.poolSize, threadFactory);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof FixedSupplier)) {
                    return false;
                }
                FixedSupplier that = (FixedSupplier)o;
                return this.poolSize == that.poolSize;
            }

            public int hashCode() {
                return Objects.hashCode(this.poolSize);
            }
        }

        private static class SuppliedExecutorSupplier
        extends ExecutorSupplier {
            private final Executor executor;

            public SuppliedExecutorSupplier(Executor executor) {
                this.executor = executor;
            }

            @Override
            Executor get() {
                return this.executor;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof SuppliedExecutorSupplier)) {
                    return false;
                }
                SuppliedExecutorSupplier that = (SuppliedExecutorSupplier)o;
                return Objects.equals(this.executor, that.executor);
            }

            public int hashCode() {
                return Objects.hashCode(this.executor);
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                throw new InvalidClassException(this.getClass().getName() + "; Not serializable");
            }
        }
    }

    @BetaApi
    @Immutable
    public static abstract class BufferAllocationStrategy
    extends Factory<BufferHandlePool>
    implements Serializable {
        private BufferAllocationStrategy() {
        }

        @BetaApi
        public static BufferAllocationStrategy simple(int capacity) {
            Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"bufferCapacity must be > 0");
            return new SimpleBufferAllocationStrategy(capacity);
        }

        @BetaApi
        public static BufferAllocationStrategy fixedPool(int bufferCount, int bufferCapacity) {
            Preconditions.checkArgument((bufferCount > 0 ? 1 : 0) != 0, (Object)"bufferCount must be > 0");
            Preconditions.checkArgument((bufferCapacity > 0 ? 1 : 0) != 0, (Object)"bufferCapacity must be > 0");
            return new FixedPoolBufferAllocationStrategy(bufferCount, bufferCapacity);
        }

        private static class SimpleBufferAllocationStrategy
        extends BufferAllocationStrategy {
            private static final long serialVersionUID = 8884826090481043434L;
            private final int capacity;

            private SimpleBufferAllocationStrategy(int capacity) {
                this.capacity = capacity;
            }

            @Override
            BufferHandlePool get() {
                return BufferHandlePool.simple(this.capacity);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof SimpleBufferAllocationStrategy)) {
                    return false;
                }
                SimpleBufferAllocationStrategy that = (SimpleBufferAllocationStrategy)o;
                return this.capacity == that.capacity;
            }

            public int hashCode() {
                return Objects.hashCode(this.capacity);
            }
        }

        private static class FixedPoolBufferAllocationStrategy
        extends BufferAllocationStrategy {
            private static final long serialVersionUID = 3288902741819257066L;
            private final int bufferCount;
            private final int bufferCapacity;

            private FixedPoolBufferAllocationStrategy(int bufferCount, int bufferCapacity) {
                this.bufferCount = bufferCount;
                this.bufferCapacity = bufferCapacity;
            }

            @Override
            BufferHandlePool get() {
                return BufferHandlePool.fixedPool(this.bufferCount, this.bufferCapacity);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof FixedPoolBufferAllocationStrategy)) {
                    return false;
                }
                FixedPoolBufferAllocationStrategy that = (FixedPoolBufferAllocationStrategy)o;
                return this.bufferCount == that.bufferCount && this.bufferCapacity == that.bufferCapacity;
            }

            public int hashCode() {
                return Objects.hash(this.bufferCount, this.bufferCapacity);
            }
        }
    }

    @BetaApi
    @Immutable
    public static abstract class PartMetadataFieldDecorator
    implements Serializable {
        abstract PartMetadataFieldDecoratorInstance newInstance(Clock var1);

        @BetaApi
        public static PartMetadataFieldDecorator setCustomTimeInFuture(Duration timeInFuture) {
            Preconditions.checkNotNull((Object)timeInFuture, (Object)"timeInFuture must not be null");
            return new CustomTimeInFuture(timeInFuture);
        }

        @BetaApi
        public static PartMetadataFieldDecorator noOp() {
            return NoOp.INSTANCE;
        }

        @BetaApi
        private static final class CustomTimeInFuture
        extends PartMetadataFieldDecorator {
            private static final long serialVersionUID = -6213742554954751892L;
            private final Duration duration;

            CustomTimeInFuture(Duration duration) {
                this.duration = duration;
            }

            @Override
            PartMetadataFieldDecoratorInstance newInstance(Clock clock) {
                return builder -> {
                    OffsetDateTime futureTime = OffsetDateTime.from(clock.instant().plus(this.duration).atZone(clock.getZone()).toOffsetDateTime());
                    return builder.setCustomTimeOffsetDateTime(futureTime);
                };
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof CustomTimeInFuture)) {
                    return false;
                }
                CustomTimeInFuture that = (CustomTimeInFuture)o;
                return Objects.equals(this.duration, that.duration);
            }

            public int hashCode() {
                return Objects.hashCode(this.duration);
            }
        }

        private static final class NoOp
        extends PartMetadataFieldDecorator {
            private static final long serialVersionUID = -4569486383992999205L;
            private static final NoOp INSTANCE = new NoOp();

            private NoOp() {
            }

            @Override
            PartMetadataFieldDecoratorInstance newInstance(Clock clock) {
                return builder -> builder;
            }

            private Object readResolve() {
                return INSTANCE;
            }
        }
    }

    static interface PartMetadataFieldDecoratorInstance
    extends UnaryOperator<BlobInfo.Builder> {
    }

    private class ParallelCompositeUploadWriterFactory
    implements BlobWriteSessionConfig.WriterFactory {
        private final Clock clock;
        private final Executor executor;
        private final BufferHandlePool bufferHandlePool;
        private final PartMetadataFieldDecoratorInstance partMetadataFieldDecoratorInstance;

        private ParallelCompositeUploadWriterFactory(Clock clock, Executor executor, BufferHandlePool bufferHandlePool, PartMetadataFieldDecoratorInstance partMetadataFieldDecoratorInstance) {
            this.clock = clock;
            this.executor = executor;
            this.bufferHandlePool = bufferHandlePool;
            this.partMetadataFieldDecoratorInstance = partMetadataFieldDecoratorInstance;
        }

        @Override
        public WritableByteChannelSession<?, BlobInfo> writeSession(StorageInternal s, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
            BlobInfo trimmed = info.toBuilder().clearCrc32c().clearMd5().build();
            return new PCUSession(s, trimmed, opts);
        }

        private final class PCUSession
        implements WritableByteChannelSession<BufferedWritableByteChannelSession.BufferedWritableByteChannel, BlobInfo> {
            private final SettableApiFuture<BlobInfo> result;
            private final StorageInternal storageInternal;
            private final BlobInfo info;
            private final UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts;

            private PCUSession(StorageInternal storageInternal, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
                this.storageInternal = storageInternal;
                this.info = info;
                this.opts = opts;
                this.result = SettableApiFuture.create();
            }

            @Override
            public ApiFuture<BufferedWritableByteChannelSession.BufferedWritableByteChannel> openAsync() {
                ParallelCompositeUploadWritableByteChannel channel = new ParallelCompositeUploadWritableByteChannel(ParallelCompositeUploadWriterFactory.this.bufferHandlePool, ParallelCompositeUploadWriterFactory.this.executor, ParallelCompositeUploadBlobWriteSessionConfig.this.partNamingStrategy, ParallelCompositeUploadBlobWriteSessionConfig.this.partCleanupStrategy, ParallelCompositeUploadBlobWriteSessionConfig.this.maxPartsPerCompose, ParallelCompositeUploadWriterFactory.this.partMetadataFieldDecoratorInstance, this.result, this.storageInternal, this.info, this.opts);
                return ApiFutures.immediateFuture((Object)StorageByteChannels.writable().createSynchronized(channel));
            }

            @Override
            public ApiFuture<BlobInfo> getResult() {
                return this.result;
            }
        }
    }

    private static abstract class Factory<T>
    implements Serializable {
        private static final long serialVersionUID = 271806144227661056L;

        private Factory() {
        }

        abstract T get();
    }
}

