/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.common;

import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class MapBackedConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = -7159956218217228877L;
    private final Map<String, String> properties;
    private final boolean hasProfiledName;

    public MapBackedConfigSource(String name, Map<String, String> propertyMap) {
        this(name, propertyMap, 100);
    }

    public MapBackedConfigSource(String name, Map<String, String> propertyMap, boolean copy) {
        this(name, propertyMap, 100, copy);
    }

    public MapBackedConfigSource(String name, Map<String, String> propertyMap, int defaultOrdinal) {
        super(name, ConfigSourceUtil.getOrdinalFromMap(propertyMap, defaultOrdinal));
        this.properties = Collections.unmodifiableMap(propertyMap);
        this.hasProfiledName = ConfigSourceUtil.hasProfiledName(this.getPropertyNames());
    }

    public MapBackedConfigSource(String name, Map<String, String> propertyMap, int defaultOrdinal, boolean copy) {
        this(name, (Map<String, String>)(copy ? new LinkedHashMap(propertyMap) : propertyMap), defaultOrdinal);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public String getValue(String propertyName) {
        if (!this.hasProfiledName && !propertyName.isEmpty() && propertyName.charAt(0) == '%') {
            return null;
        }
        return this.properties.get(propertyName);
    }
}

