/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.view.BaseViewHistoryEntry;
import org.apache.iceberg.view.ViewHistoryEntry;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BaseViewHistoryEntry", generator="Immutables")
@Immutable
public final class ImmutableViewHistoryEntry
implements BaseViewHistoryEntry {
    private final long timestampMillis;
    private final int versionId;

    private ImmutableViewHistoryEntry(long timestampMillis, int versionId) {
        this.timestampMillis = timestampMillis;
        this.versionId = versionId;
    }

    public long timestampMillis() {
        return this.timestampMillis;
    }

    public int versionId() {
        return this.versionId;
    }

    public final ImmutableViewHistoryEntry withTimestampMillis(long value) {
        if (this.timestampMillis == value) {
            return this;
        }
        return new ImmutableViewHistoryEntry(value, this.versionId);
    }

    public final ImmutableViewHistoryEntry withVersionId(int value) {
        if (this.versionId == value) {
            return this;
        }
        return new ImmutableViewHistoryEntry(this.timestampMillis, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableViewHistoryEntry && this.equalsByValue((ImmutableViewHistoryEntry)another);
    }

    private boolean equalsByValue(ImmutableViewHistoryEntry another) {
        return this.timestampMillis == another.timestampMillis && this.versionId == another.versionId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.timestampMillis);
        h += (h << 5) + this.versionId;
        return h;
    }

    public String toString() {
        return "BaseViewHistoryEntry{timestampMillis=" + this.timestampMillis + ", versionId=" + this.versionId + "}";
    }

    static ImmutableViewHistoryEntry copyOf(BaseViewHistoryEntry instance) {
        if (instance instanceof ImmutableViewHistoryEntry) {
            return (ImmutableViewHistoryEntry)instance;
        }
        return ImmutableViewHistoryEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BaseViewHistoryEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIMESTAMP_MILLIS = 1L;
        private static final long INIT_BIT_VERSION_ID = 2L;
        private long initBits = 3L;
        private long timestampMillis;
        private int versionId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ViewHistoryEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ImmutableViewHistoryEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseViewHistoryEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            ViewHistoryEntry instance;
            long bits = 0L;
            if (object instanceof ViewHistoryEntry) {
                instance = (ViewHistoryEntry)object;
                if ((bits & 1L) == 0L) {
                    this.versionId(instance.versionId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.timestampMillis(instance.timestampMillis());
                    bits |= 2L;
                }
            }
            if (object instanceof BaseViewHistoryEntry) {
                instance = (BaseViewHistoryEntry)object;
                if ((bits & 1L) == 0L) {
                    this.versionId(instance.versionId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.timestampMillis(instance.timestampMillis());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder timestampMillis(long timestampMillis) {
            this.timestampMillis = timestampMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder versionId(int versionId) {
            this.versionId = versionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableViewHistoryEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableViewHistoryEntry(this.timestampMillis, this.versionId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("timestampMillis");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("versionId");
            }
            return "Cannot build BaseViewHistoryEntry, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

