/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.rest.HTTPHeaders;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HTTPHeaders", generator="Immutables")
@Immutable
public final class ImmutableHTTPHeaders
implements HTTPHeaders {
    private final Set<HTTPHeaders.HTTPHeader> entries;

    private ImmutableHTTPHeaders(Set<HTTPHeaders.HTTPHeader> entries) {
        this.entries = entries;
    }

    @Override
    public Set<HTTPHeaders.HTTPHeader> entries() {
        return this.entries;
    }

    public final ImmutableHTTPHeaders withEntries(HTTPHeaders.HTTPHeader ... elements) {
        Set<HTTPHeaders.HTTPHeader> newValue = ImmutableHTTPHeaders.createUnmodifiableSet(ImmutableHTTPHeaders.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHTTPHeaders(newValue);
    }

    public final ImmutableHTTPHeaders withEntries(Iterable<? extends HTTPHeaders.HTTPHeader> elements) {
        if (this.entries == elements) {
            return this;
        }
        Set<HTTPHeaders.HTTPHeader> newValue = ImmutableHTTPHeaders.createUnmodifiableSet(ImmutableHTTPHeaders.createSafeList(elements, true, false));
        return new ImmutableHTTPHeaders(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHTTPHeaders && this.equalsByValue((ImmutableHTTPHeaders)another);
    }

    private boolean equalsByValue(ImmutableHTTPHeaders another) {
        return this.entries.equals(another.entries);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entries.hashCode();
        return h;
    }

    public String toString() {
        return "HTTPHeaders{entries=" + String.valueOf(this.entries) + "}";
    }

    public static ImmutableHTTPHeaders copyOf(HTTPHeaders instance) {
        if (instance instanceof ImmutableHTTPHeaders) {
            return (ImmutableHTTPHeaders)instance;
        }
        return ImmutableHTTPHeaders.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="HTTPHeaders", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<HTTPHeaders.HTTPHeader> entries = new ArrayList<HTTPHeaders.HTTPHeader>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HTTPHeaders instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllEntries(instance.entries());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntry(HTTPHeaders.HTTPHeader element) {
            this.entries.add(Objects.requireNonNull(element, "entries element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntries(HTTPHeaders.HTTPHeader ... elements) {
            for (HTTPHeaders.HTTPHeader element : elements) {
                this.entries.add(Objects.requireNonNull(element, "entries element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entries(Iterable<? extends HTTPHeaders.HTTPHeader> elements) {
            this.entries.clear();
            return this.addAllEntries(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEntries(Iterable<? extends HTTPHeaders.HTTPHeader> elements) {
            for (HTTPHeaders.HTTPHeader hTTPHeader : elements) {
                this.entries.add(Objects.requireNonNull(hTTPHeader, "entries element"));
            }
            return this;
        }

        public ImmutableHTTPHeaders build() {
            return new ImmutableHTTPHeaders(ImmutableHTTPHeaders.createUnmodifiableSet(this.entries));
        }
    }
}

