/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.OtlpConfigUtil;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import io.opentelemetry.sdk.trace.export.SpanExporter;

public class OtlpSpanExporterComponentProvider
implements ComponentProvider<SpanExporter> {
    public Class<SpanExporter> getType() {
        return SpanExporter.class;
    }

    public String getName() {
        return "otlp";
    }

    public SpanExporter create(StructuredConfigProperties config) {
        String protocol = OtlpConfigUtil.getStructuredConfigOtlpProtocol(config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpSpanExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcSpanExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    OtlpHttpSpanExporterBuilder httpBuilder() {
        return OtlpHttpSpanExporter.builder();
    }

    OtlpGrpcSpanExporterBuilder grpcBuilder() {
        return OtlpGrpcSpanExporter.builder();
    }
}

