/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.storage.aws;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CaffeineStatsCounter;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.polaris.core.storage.aws.StsClientProvider;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;

public class StsClientsPool
implements StsClientProvider {
    private static final String CACHE_NAME = "sts-clients";
    private final Cache<StsClientProvider.StsDestination, StsClient> clients;
    private final Function<StsClientProvider.StsDestination, StsClient> clientBuilder;

    public StsClientsPool(int clientsCacheMaxSize, SdkHttpClient sdkHttpClient, MeterRegistry meterRegistry) {
        this(clientsCacheMaxSize, (StsClientProvider.StsDestination key) -> StsClientsPool.defaultStsClient(key, sdkHttpClient), Optional.ofNullable(meterRegistry));
    }

    @VisibleForTesting
    StsClientsPool(int maxSize, Function<StsClientProvider.StsDestination, StsClient> clientBuilder, Optional<MeterRegistry> meterRegistry) {
        this.clientBuilder = clientBuilder;
        this.clients = Caffeine.newBuilder().maximumSize((long)maxSize).recordStats(() -> StsClientsPool.statsCounter(meterRegistry, maxSize)).build();
    }

    public StsClient stsClient(StsClientProvider.StsDestination destination) {
        return (StsClient)this.clients.get((Object)destination, this.clientBuilder);
    }

    private static StsClient defaultStsClient(StsClientProvider.StsDestination parameters, SdkHttpClient sdkClient) {
        StsClientBuilder builder = StsClient.builder();
        builder.httpClient(sdkClient);
        if (parameters.endpoint().isPresent()) {
            CompletableFuture<Endpoint> endpointFuture = CompletableFuture.completedFuture(Endpoint.builder().url((URI)parameters.endpoint().get()).build());
            builder.endpointProvider(params -> endpointFuture);
        }
        parameters.region().ifPresent(r -> builder.region(Region.of((String)r)));
        return (StsClient)builder.build();
    }

    static StatsCounter statsCounter(Optional<MeterRegistry> meterRegistry, int maxSize) {
        if (meterRegistry.isPresent()) {
            meterRegistry.get().gauge("max_entries", Collections.singletonList(Tag.of((String)"cache", (String)CACHE_NAME)), (Object)"", x -> maxSize);
            return new CaffeineStatsCounter(meterRegistry.get(), CACHE_NAME);
        }
        return StatsCounter.disabledStatsCounter();
    }
}

