/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.context;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.context.RealmContextConfiguration;
import org.apache.polaris.service.context.RealmContextResolver;

@ApplicationScoped
@Identifier(value="default")
public class DefaultRealmContextResolver
implements RealmContextResolver {
    private final RealmContextConfiguration configuration;

    @Inject
    public DefaultRealmContextResolver(RealmContextConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public CompletionStage<RealmContext> resolveRealmContext(String requestURL, String method, String path, Function<String, String> headers) {
        try {
            String realm = this.resolveRealmIdentifier(headers);
            return CompletableFuture.completedFuture(() -> realm);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private String resolveRealmIdentifier(Function<String, String> headers) {
        String realm = headers.apply(this.configuration.headerName());
        if (realm != null) {
            if (!this.configuration.realms().contains(realm)) {
                throw new IllegalArgumentException("Unknown realm: " + realm);
            }
        } else {
            if (this.configuration.requireHeader()) {
                throw new IllegalArgumentException("Missing required realm header: " + this.configuration.headerName());
            }
            realm = this.configuration.defaultRealm();
        }
        return realm;
    }
}

